/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileUtil;
import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.PackageInfo;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;

public class AtomicOutput
implements Closable {
    private File mDest;
    private File mTemp;
    private boolean mValid = false;
    private boolean mPreservePerms = false;

    public AtomicOutput(File dest) throws IOException {
        this(dest, false);
    }

    public AtomicOutput(File dest, boolean preservePerms) throws IOException {
        this.mDest = dest;
        this.mTemp = File.createTempFile(TempFile.getDefaultPrefix(), TempFile.getDefaultSuffix());
        this.mPreservePerms = preservePerms;
    }

    public File getOutput() {
        return this.mTemp;
    }

    public File getDestination() {
        return this.mDest;
    }

    public void setValid(boolean valid) {
        this.mValid = valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws IOException {
        boolean toBeDeleted = true;
        if (this.mTemp == null) {
            return;
        }
        if (this.mValid && !this.mPreservePerms) {
            FileUtil.ensureDeleted(this.mDest);
            if (this.mTemp.renameTo(this.mDest)) {
                this.mTemp = null;
                return;
            }
        }
        try {
            if (this.mValid) {
                try {
                    CopyUtil.copyBinary(this.mTemp.getAbsolutePath(), this.mDest.getAbsolutePath());
                }
                catch (IOException io) {
                    if (!this.mPreservePerms) throw io;
                    toBeDeleted = false;
                    throw new IOException(PackageInfo.errorInOverwrite(this.mDest.getAbsolutePath(), this.mTemp.getAbsolutePath()));
                }
            }
            Object var4_3 = null;
            if (!toBeDeleted) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!toBeDeleted) throw throwable;
            if (!this.mTemp.delete() && Logger.isWarnEnabled(this)) {
                Logger.warn(PackageInfo.createNoDelete(this.mTemp), this);
            }
            this.mTemp = null;
            throw throwable;
        }
        if (!this.mTemp.delete() && Logger.isWarnEnabled(this)) {
            Logger.warn(PackageInfo.createNoDelete(this.mTemp), this);
        }
        this.mTemp = null;
    }
}

