/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import com.raplix.util.graphs.DEdge;
import com.raplix.util.graphs.DVertex;

public class DFSVertexInfo {
    private DVertex mVertex;
    private int mDiscoveryTime;
    private DFSVertexInfo mParentVertex;
    private DEdge mParentEdge;
    private int mFinishTime;

    DFSVertexInfo(DVertex vertex) {
        this.mVertex = vertex;
    }

    public DVertex getVertex() {
        return this.mVertex;
    }

    public boolean isWhite() {
        return this.getDiscoveryTime() == 0;
    }

    public boolean isGray() {
        return !this.isWhite() && this.getFinishTime() == 0;
    }

    public boolean isBlack() {
        return this.getFinishTime() != 0;
    }

    public int getDiscoveryTime() {
        return this.mDiscoveryTime;
    }

    void setDiscoveryTime(int discoveryTime) {
        this.mDiscoveryTime = discoveryTime;
    }

    public int getFinishTime() {
        return this.mFinishTime;
    }

    void setFinishTime(int finishTime) {
        this.mFinishTime = finishTime;
    }

    public DFSVertexInfo getParentVertex() {
        return this.mParentVertex;
    }

    void setParentVertex(DFSVertexInfo vertex) {
        this.mParentVertex = vertex;
    }

    public DEdge getParentEdge() {
        return this.mParentEdge;
    }

    void setParentEdge(DEdge edge) {
        this.mParentEdge = edge;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this.getVertex());
        buffer.append(',');
        if (this.isWhite()) {
            buffer.append("white");
        } else {
            buffer.append(this.getDiscoveryTime());
            if (this.isBlack()) {
                buffer.append(',');
                buffer.append(this.getFinishTime());
            }
            buffer.append(',');
            buffer.append(this.getParentEdge());
        }
        buffer.append(')');
        return buffer.toString();
    }
}

