/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.graphs.DEdge;
import com.raplix.util.graphs.DFSVertexInfo;
import com.raplix.util.graphs.DFSVisitor;
import com.raplix.util.graphs.DFSVisitorBase;
import com.raplix.util.graphs.DGraph;
import com.raplix.util.graphs.DVertex;
import java.util.Hashtable;

public class DFS {
    private DFSVertexInfo[] mInfo;
    private Hashtable mMap = new Hashtable();
    private DFSVisitor mVisitor;
    private int mTime;

    public DFS(DGraph graph, DFSVisitor visitor, DVertex source) {
        this.mVisitor = visitor;
        DVertex[] vs = graph.getVertices();
        this.mInfo = new DFSVertexInfo[vs.length];
        DFSVertexInfo s = null;
        for (int i = 0; i < vs.length; ++i) {
            this.mInfo[i] = new DFSVertexInfo(vs[i]);
            this.mMap.put(vs[i], this.mInfo[i]);
            if (!vs[i].equals(source)) continue;
            s = this.mInfo[i];
        }
        this.visit(s);
    }

    public DFS(DGraph graph, DVertex source) {
        this(graph, new DFSVisitorBase(), source);
    }

    public DFS(DGraph graph, DFSVisitor visitor) {
        int i;
        this.mVisitor = visitor;
        DVertex[] vs = graph.getVertices();
        this.mInfo = new DFSVertexInfo[vs.length];
        for (i = 0; i < vs.length; ++i) {
            this.mInfo[i] = new DFSVertexInfo(vs[i]);
            this.mMap.put(vs[i], this.mInfo[i]);
        }
        for (i = 0; i < this.mInfo.length; ++i) {
            if (!this.mInfo[i].isWhite()) continue;
            this.visit(this.mInfo[i]);
        }
    }

    public DFS(DGraph graph) {
        this(graph, new DFSVisitorBase());
    }

    private void visit(DFSVertexInfo u) {
        u.setDiscoveryTime(++this.mTime);
        this.mVisitor.discovered(u);
        DEdge[] e = u.getVertex().getLeavingEdges();
        for (int i = 0; i < e.length; ++i) {
            DFSVertexInfo v = this.getInfo(e[i].getIncidentTo());
            this.mVisitor.exploring(e[i], u, v);
            if (!v.isWhite()) continue;
            v.setParentVertex(u);
            v.setParentEdge(e[i]);
            this.visit(v);
        }
        u.setFinishTime(++this.mTime);
        this.mVisitor.finished(u);
    }

    public DFSVertexInfo[] getAllInfo() {
        return this.mInfo;
    }

    public DFSVertexInfo getInfo(DVertex v) {
        return (DFSVertexInfo)this.mMap.get(v);
    }

    public String toString() {
        return CollectionUtil.toString(this.getAllInfo(), "", ";");
    }
}

