/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import [Lcom.raplix.util.graphs.DFSVertexInfo;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.graphs.DEdge;
import com.raplix.util.graphs.DFS;
import com.raplix.util.graphs.DFSVertexInfo;
import com.raplix.util.graphs.DFSVisitorBase;
import com.raplix.util.graphs.DGraph;
import com.raplix.util.graphs.DVertex;
import com.raplix.util.string.StringUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class CycleAnalysis {
    private boolean mUndirectedOriginal;
    private boolean mSummary;
    private boolean mHasCycle;
    private boolean mDetailComputed;
    private Vector mCyclesV;
    private DFSVertexInfo[] mCyclesA;
    private DFSVertexInfo[] mSort;

    public CycleAnalysis(DGraph graph, boolean undirectedOriginal, boolean summary) {
        this.mUndirectedOriginal = undirectedOriginal;
        this.mSummary = summary;
        if (!this.isSummary()) {
            this.mCyclesV = new Vector();
        }
        try {
            this.mSort = new DFS(graph, new Visitor()).getAllInfo();
        }
        catch (CycleFoundException ex) {
            // empty catch block
        }
    }

    public CycleAnalysis(DGraph graph) {
        this(graph, false, false);
    }

    public boolean isUndirectedOriginal() {
        return this.mUndirectedOriginal;
    }

    public boolean isSummary() {
        return this.mSummary;
    }

    public boolean hasCycle() {
        return this.mHasCycle;
    }

    public DFSVertexInfo[] getBackEdges() {
        if (!this.mDetailComputed) {
            this.mCyclesA = (DFSVertexInfo[])CollectionUtil.mapClass(this.mCyclesV, DFSVertexInfo;.class);
            this.mDetailComputed = true;
        }
        return this.mCyclesA;
    }

    public DFSVertexInfo[] getSort() {
        if (!this.mDetailComputed) {
            Arrays.sort(this.mSort, new CompareFinishTimes());
            this.mDetailComputed = true;
        }
        return this.mSort;
    }

    public String toString() {
        if (this.isSummary()) {
            return this.hasCycle() ? "cyclic" : "acyclic";
        }
        if (!this.hasCycle()) {
            return "sort:" + CollectionUtil.toString(this.getSort(), "", ";");
        }
        StringBuffer buffer = new StringBuffer("back edges:");
        for (int i = 0; i < this.getBackEdges().length; ++i) {
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append('[');
            DFSVertexInfo edge = this.getBackEdges()[i];
            DVertex lastVertex = edge.getVertex();
            while (true) {
                buffer.append(edge);
                DFSVertexInfo next = edge.getParentVertex();
                if (next.getVertex().equals(lastVertex)) break;
                buffer.append(';');
                edge = next;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    private static class CompareFinishTimes
    implements Comparator {
        private CompareFinishTimes() {
        }

        public int compare(Object o1, Object o2) {
            return ((DFSVertexInfo)o2).getFinishTime() - ((DFSVertexInfo)o1).getFinishTime();
        }
    }

    private class Visitor
    extends DFSVisitorBase {
        private Visitor() {
        }

        public void exploring(DEdge edge, DFSVertexInfo incidentFrom, DFSVertexInfo incidentTo) {
            if (incidentTo.isGray()) {
                if (CycleAnalysis.this.isUndirectedOriginal() && incidentFrom.getParentVertex().getVertex().equals(incidentTo.getVertex())) {
                    return;
                }
                CycleAnalysis.this.mHasCycle = true;
                if (CycleAnalysis.this.isSummary()) {
                    throw new CycleFoundException();
                }
                DFSVertexInfo cycle = new DFSVertexInfo(incidentTo.getVertex());
                cycle.setParentVertex(incidentFrom);
                cycle.setParentEdge(edge);
                CycleAnalysis.this.mCyclesV.addElement(cycle);
            }
        }
    }

    private static class CycleFoundException
    extends RuntimeException {
        private CycleFoundException() {
        }
    }
}

