/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.graphs.BFSVertexInfo;
import com.raplix.util.graphs.DEdge;
import com.raplix.util.graphs.DGraph;
import com.raplix.util.graphs.DVertex;
import java.util.Hashtable;
import java.util.LinkedList;

public class BFS {
    private BFSVertexInfo[] mInfo;
    private Hashtable mMap = new Hashtable();

    public BFS(DGraph graph, DVertex source) {
        DVertex[] vs = graph.getVertices();
        this.mInfo = new BFSVertexInfo[vs.length];
        BFSVertexInfo s = null;
        for (int i = 0; i < vs.length; ++i) {
            this.mInfo[i] = new BFSVertexInfo(vs[i]);
            this.mMap.put(vs[i], this.mInfo[i]);
            if (!vs[i].equals(source)) continue;
            s = this.mInfo[i];
        }
        this.visit(s);
    }

    public BFS(DGraph graph) {
        int i;
        DVertex[] vs = graph.getVertices();
        this.mInfo = new BFSVertexInfo[vs.length];
        for (i = 0; i < vs.length; ++i) {
            this.mInfo[i] = new BFSVertexInfo(vs[i]);
            this.mMap.put(vs[i], this.mInfo[i]);
        }
        for (i = 0; i < this.mInfo.length; ++i) {
            if (this.mInfo[i].isVisited()) continue;
            this.visit(this.mInfo[i]);
        }
    }

    private void visit(BFSVertexInfo s) {
        s.setDistance(0);
        LinkedList<BFSVertexInfo> q = new LinkedList<BFSVertexInfo>();
        q.addLast(s);
        while (q.size() > 0) {
            BFSVertexInfo u = (BFSVertexInfo)q.removeFirst();
            DEdge[] e = u.getVertex().getLeavingEdges();
            for (int i = 0; i < e.length; ++i) {
                BFSVertexInfo v = this.getInfo(e[i].getIncidentTo());
                if (v.isVisited()) continue;
                v.setDistance(u.getDistance() + 1);
                v.setParentVertex(u);
                v.setParentEdge(e[i]);
                q.addLast(v);
            }
        }
    }

    public BFSVertexInfo[] getAllInfo() {
        return this.mInfo;
    }

    public BFSVertexInfo getInfo(DVertex v) {
        return (BFSVertexInfo)this.mMap.get(v);
    }

    public String toString() {
        return CollectionUtil.toString(this.getAllInfo(), "", ";");
    }
}

