/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import com.raplix.util.DelayedCreator;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.graphs.AEdge;
import com.raplix.util.graphs.AVertex;
import com.raplix.util.graphs.DataCarrier;
import com.raplix.util.string.StringUtil;
import java.util.HashSet;

abstract class AGraph
extends DataCarrier {
    protected HashSet mVerticesS = new HashSet();
    protected HashSet mEdgesS = new HashSet();
    private DelayedCreator mVerticesA;
    private DelayedCreator mEdgesA;

    protected AGraph(Object data, final Class verticesClass, final Class edgesClass) {
        super(data);
        this.mVerticesA = new DelayedCreator(){

            protected Object create() {
                return CollectionUtil.mapClass(AGraph.this.mVerticesS, verticesClass);
            }
        };
        this.mEdgesA = new DelayedCreator(){

            protected Object create() {
                return CollectionUtil.mapClass(AGraph.this.mEdgesS, edgesClass);
            }
        };
    }

    protected AGraph(AVertex[] vertices, AEdge[] edges, Object data, Class verticesClass, Class edgesClass) {
        this(data, verticesClass, edgesClass);
        int i;
        for (i = 0; i < vertices.length; ++i) {
            this.addAVertex(vertices[i]);
        }
        for (i = 0; i < edges.length; ++i) {
            this.addAEdge(edges[i]);
        }
    }

    protected AVertex[] getAVertices() {
        return (AVertex[])this.mVerticesA.getValue();
    }

    protected AEdge[] getAEdges() {
        return (AEdge[])this.mEdgesA.getValue();
    }

    protected void addAVertex(AVertex vertex) {
        if (!this.mVerticesS.add(vertex)) {
            return;
        }
        this.mVerticesA.reset();
    }

    protected void removeAVertex(AVertex vertex) {
        if (!this.mVerticesS.remove(vertex)) {
            return;
        }
        this.mVerticesA.reset();
    }

    protected void addAEdge(AEdge edge) {
        if (!this.mEdgesS.add(edge)) {
            return;
        }
        this.mEdgesA.reset();
        edge.getSource().addAEdge(edge);
    }

    protected void removeAEdge(AEdge edge) {
        if (!this.mEdgesS.remove(edge)) {
            return;
        }
        this.mEdgesA.reset();
        edge.getSource().removeAEdge(edge);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(CollectionUtil.toString(this.mVerticesS, "", ","));
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(CollectionUtil.toString(this.mEdgesS, "", ";"));
        return buffer.toString();
    }
}

