/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.graphs;

import com.raplix.util.graphs.ADEdge;
import com.raplix.util.graphs.ADGraph;
import com.raplix.util.graphs.ADVertex;
import com.raplix.util.graphs.UEdge;
import com.raplix.util.graphs.UGraph;
import com.raplix.util.graphs.UVertex;
import java.util.Hashtable;

public class ADWrapperUGraph
extends ADGraph {
    private Hashtable mMap = new Hashtable();

    public ADWrapperUGraph(UGraph graph, Object data) {
        super(data);
        UVertex[] vIn = graph.getVertices();
        for (int i = 0; i < vIn.length; ++i) {
            ADVertex v = new ADVertex(vIn[i]);
            this.addVertex(v);
            this.mMap.put(vIn[i], v);
        }
        UEdge[] e = graph.getEdges();
        for (int i = 0; i < e.length; ++i) {
            ADVertex vLeft = this.getVertex(e[i].getIncidentOnLeft());
            ADVertex vRight = this.getVertex(e[i].getIncidentOnRight());
            this.addEdge(new ADEdge(vLeft, vRight, (Object)e[i]));
            this.addEdge(new ADEdge(vRight, vLeft, (Object)e[i]));
        }
    }

    public ADWrapperUGraph(UGraph graph) {
        this(graph, null);
    }

    public ADVertex getVertex(UVertex vertex) {
        return (ADVertex)this.mMap.get(vertex);
    }
}

