/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.filecache;

import com.raplix.util.filecache.CachedFileSpec;
import com.raplix.util.filecache.DirectoryFileCache;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.filecache.PackageInfo;
import com.raplix.util.filecache.SerializableKey;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class Resolver {
    private FileCache mFileCache;
    private HashMap mSpecMap = new HashMap();
    private final Object mKey;
    private final Object mReferentKey = new Object();

    Resolver(FileCache cache, Object key) {
        this.mFileCache = cache;
        this.mKey = key;
    }

    public File getCachedFile(File file) throws IOException {
        CachedFileSpec spec = (CachedFileSpec)this.mSpecMap.get(file);
        if (spec == null) {
            spec = this.mFileCache.lockCachedFile(file);
            this.mSpecMap.put(file, spec);
        }
        return spec.getCachedFile();
    }

    public File getCachedDirResource(File file) throws IOException {
        DirectoryFileCache resourceCache = this.mFileCache.getResourceCache();
        if (resourceCache == null) {
            throw PackageInfo.createDirectoryCacheNotAvailable();
        }
        return resourceCache.getCachedFile(file.getAbsolutePath(), (SerializableKey)this.mKey, this.mReferentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        FileCache fileCache = this.mFileCache;
        synchronized (fileCache) {
            if (this.mSpecMap == null) {
                return;
            }
            Iterator specs = this.mSpecMap.entrySet().iterator();
            this.mSpecMap = null;
            while (specs.hasNext()) {
                CachedFileSpec spec = (CachedFileSpec)specs.next().getValue();
                this.mFileCache.unlock(spec);
            }
            this.mFileCache.flushDirtyFiles();
        }
        if (this.mFileCache.getResourceCache() != null) {
            this.mFileCache.getResourceCache().doneUsing((SerializableKey)this.mKey, this.mReferentKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    Object getKey() {
        return this.mKey;
    }
}

