/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.filecache;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.filecache.CachedFileSpec;
import com.raplix.util.filecache.DirectoryFileCache;
import com.raplix.util.filecache.Resolver;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class FileCache {
    private HashMap mFileMap;
    private HashMap mFilesInUse;
    private File mCacheRootDir;
    private String mFileSuffix;
    private String mFilePrefix;
    private File mFileMapFile;
    private boolean mShouldFlush;
    private DirectoryFileCache mResourceCache = null;

    public FileCache(File cacheRootDir, File resourceCacheDir, String filePrefix, String fileSuffix) {
        cacheRootDir.mkdirs();
        if (resourceCacheDir != null) {
            this.mResourceCache = new DirectoryFileCache(resourceCacheDir);
        }
        this.mCacheRootDir = cacheRootDir;
        this.mFileSuffix = fileSuffix;
        this.mFilePrefix = filePrefix;
        this.mFileMapFile = new File(cacheRootDir, filePrefix + "FileMap.ser");
        this.load();
        this.flushDirtyFiles();
    }

    File getCacheRootDir() {
        return this.mCacheRootDir;
    }

    String getFileSuffix() {
        return this.mFileSuffix;
    }

    String getFilePrefix() {
        return this.mFilePrefix;
    }

    private File getFileMapFile() {
        return this.mFileMapFile;
    }

    public Resolver createResolver(Object key) {
        return new Resolver(this, key);
    }

    public synchronized File getCachedFile(File file) throws IOException {
        return this.getCachedFileSpec(file).getCachedFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedFileSpec getCachedFileSpec(File file) throws IOException {
        if (!file.isFile()) {
            try {
                this.save(null, (CachedFileSpec)this.mFileMap.get(file));
            }
            finally {
                throw new FileNotFoundException(file.toString());
            }
        }
        CachedFileSpec oldSpec = null;
        CachedFileSpec spec = (CachedFileSpec)this.mFileMap.get(file);
        if (spec != null && !spec.isSameFile(file)) {
            oldSpec = spec;
            spec = null;
        }
        if (spec == null) {
            spec = this.save(file, oldSpec);
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedFileSpec save(File file, CachedFileSpec oldSpec) throws IOException {
        if (oldSpec != null) {
            this.remove(oldSpec);
        }
        boolean saved = false;
        CachedFileSpec newSpec = null;
        try {
            if (file != null) {
                newSpec = new CachedFileSpec(file, this);
                this.add(newSpec);
            }
            if (oldSpec != null || newSpec != null) {
                this.save();
            }
            saved = true;
            Object var6_5 = null;
            if (!saved) {
                if (newSpec != null) {
                    this.remove(newSpec);
                }
                if (oldSpec != null) {
                    this.add(oldSpec);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!saved) {
                if (newSpec != null) {
                    this.remove(newSpec);
                }
                if (oldSpec != null) {
                    this.add(oldSpec);
                }
            }
            throw throwable;
        }
        this.flushDirtyFiles();
        return newSpec;
    }

    synchronized CachedFileSpec lockCachedFile(File file) throws IOException {
        CachedFileSpec spec = this.getCachedFileSpec(file);
        spec.addLock();
        return spec;
    }

    private void add(CachedFileSpec spec) {
        this.mFileMap.put(spec.getSourceFile(), spec);
        this.mFilesInUse.put(spec.getCachedFile(), spec);
    }

    private void remove(CachedFileSpec spec) {
        this.mFileMap.remove(spec.getSourceFile());
        this.removeFromUseIfUnlocked(spec);
    }

    private void removeFromUseIfUnlocked(CachedFileSpec spec) {
        if (spec.isLocked()) {
            return;
        }
        this.mFilesInUse.remove(spec.getCachedFile());
        this.mShouldFlush = true;
    }

    void unlock(CachedFileSpec spec) {
        spec.removeLock();
        if (this.mFileMap.get(spec.getSourceFile()) == spec) {
            return;
        }
        this.removeFromUseIfUnlocked(spec);
    }

    private boolean isInUse(File cachedFile) {
        return this.mFilesInUse.containsKey(cachedFile);
    }

    void flushDirtyFiles() {
        if (!this.mShouldFlush) {
            return;
        }
        File[] files = this.getCacheRootDir().listFiles(new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                return name.startsWith(FileCache.this.getFilePrefix()) && name.endsWith(FileCache.this.getFileSuffix()) && f.isFile() && !FileCache.this.isInUse(f);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File dirtyFile = files[i];
            boolean success = dirtyFile.delete();
            if (!Logger.isInfoEnabled(this)) continue;
            Logger.info("removing dirty file: " + dirtyFile + ", success = " + success, this);
        }
        this.mShouldFlush = false;
    }

    private void load() {
        block7: {
            File fileMapFile = this.getFileMapFile();
            this.mFileMap = null;
            if (fileMapFile.exists()) {
                try {
                    this.mFileMap = (HashMap)CopyUtil.readObject(fileMapFile.toString());
                }
                catch (ClassNotFoundException e) {
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Unable to load file cache from " + fileMapFile + ", all files will be re-read", e, this);
                    }
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block7;
                    Logger.warn("Unable to load file cache from " + fileMapFile + ", all files will be re-read", e, this);
                }
            }
        }
        if (this.mFileMap == null) {
            this.mFileMap = new HashMap();
        }
        this.mFilesInUse = new HashMap();
        Iterator specs = this.mFileMap.entrySet().iterator();
        while (specs.hasNext()) {
            CachedFileSpec spec = (CachedFileSpec)specs.next().getValue();
            this.mFilesInUse.put(spec.getCachedFile(), spec);
        }
        this.mShouldFlush = true;
    }

    private void save() throws IOException {
        CopyUtil.writeObject((Object)this.mFileMap, this.getFileMapFile().toString());
    }

    public DirectoryFileCache getResourceCache() {
        return this.mResourceCache;
    }
}

