/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.filecache;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.RecursiveDelete;
import com.raplix.util.filecache.PackageInfo;
import com.raplix.util.filecache.SerializableKey;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DirectoryFileCache {
    private HashMap mFileMap = new HashMap();
    private final File mRootDir;
    public static final String DIR_PREFIX = "lib";
    public static final String DIR_SUFFIX = ".dir";

    public DirectoryFileCache(File inRootDir) {
        this.mRootDir = inRootDir;
        this.mRootDir.mkdirs();
        this.load();
    }

    public synchronized File getCachedFile(String fileName, SerializableKey dirKey, Object referentKey) throws IOException, IllegalArgumentException {
        if (fileName == null || dirKey == null || referentKey == null) {
            throw new NullPointerException();
        }
        File file = new File(fileName).getCanonicalFile();
        File cachedFile = this.checkAndAddFile(dirKey, referentKey, file);
        if (!cachedFile.exists()) {
            CopyUtil.copyBinary(file.getAbsolutePath(), cachedFile.getAbsolutePath());
            CopyUtil.copyPermissions(file, cachedFile);
            cachedFile.setReadOnly();
            this.save();
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Cached:" + fileName + ":to:" + cachedFile, this);
            }
        }
        return cachedFile;
    }

    public File getRootDir() {
        return this.mRootDir;
    }

    public synchronized void doneUsing(SerializableKey dirKey, Object referentKey) {
        CachedDirDetails dir;
        if (dirKey == null || referentKey == null) {
            throw new NullPointerException();
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(referentKey + ": done using :" + dirKey, this);
        }
        if ((dir = (CachedDirDetails)this.mFileMap.get(dirKey)) != null) {
            dir.removeReferent(referentKey);
            this.removeStaleEntries();
        } else if (Logger.isWarnEnabled(this)) {
            Logger.warn("No entry found for:" + dirKey + ":when done using", this);
        }
    }

    private File checkAndAddFile(SerializableKey inDirKey, Object referentKey, File inFile) throws IOException {
        CachedDirDetails dirDetails = this.getCachedDir(inDirKey);
        dirDetails.addReferent(referentKey);
        return dirDetails.checkoutFile(inFile);
    }

    private CachedDirDetails getCachedDir(SerializableKey dirKey) throws IOException {
        CachedDirDetails dirDetails = (CachedDirDetails)this.mFileMap.get(dirKey);
        if (dirDetails != null && !dirDetails.getDir().isDirectory()) {
            dirDetails = null;
        }
        if (dirDetails == null) {
            File dir = File.createTempFile(DIR_PREFIX, DIR_SUFFIX, this.mRootDir);
            dir.delete();
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw PackageInfo.createCacheDirError(dir);
            }
            dirDetails = new CachedDirDetails(dir);
            this.mFileMap.put(dirKey, dirDetails);
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Created Cache Dir:" + dir.getAbsolutePath() + ":for:" + dirKey, this);
            }
        }
        return dirDetails;
    }

    private void save() throws IOException {
        CopyUtil.writeObject((Object)this.mFileMap, this.getCacheMapFile().getAbsolutePath());
    }

    private void load() {
        block5: {
            File mapFile = this.getCacheMapFile();
            if (mapFile.exists()) {
                try {
                    this.mFileMap = (HashMap)CopyUtil.readObject(mapFile.getAbsolutePath());
                }
                catch (IOException e) {
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Error loading the resource file maps", e, this);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!Logger.isWarnEnabled(this)) break block5;
                    Logger.warn("Error loading the resource file maps", e, this);
                }
            }
        }
        this.removeStaleEntries();
    }

    private File getCacheMapFile() {
        return new File(this.mRootDir, "cacheTable.ser");
    }

    private void removeStaleEntries() {
        SerializableKey[] keys = this.mFileMap.keySet().toArray(new SerializableKey[this.mFileMap.size()]);
        for (int i = 0; i < keys.length; ++i) {
            SerializableKey key = keys[i];
            CachedDirDetails details = (CachedDirDetails)this.mFileMap.get(key);
            if (details != null && (key.isCurrent() ? details.getDir().isDirectory() : details.hasReferents())) continue;
            this.mFileMap.remove(key);
            if (!Logger.isInfoEnabled(this)) continue;
            Logger.info("Removed entry:" + key, this);
        }
        final HashSet<File> dirSet = new HashSet<File>();
        Iterator iter = this.mFileMap.values().iterator();
        while (iter.hasNext()) {
            dirSet.add(((CachedDirDetails)iter.next()).getDir());
        }
        File[] removableDirs = this.mRootDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.startsWith(DirectoryFileCache.DIR_PREFIX) && name.endsWith(DirectoryFileCache.DIR_SUFFIX) && pathname.isDirectory() && !dirSet.contains(pathname);
            }
        });
        for (int i = 0; i < removableDirs.length; ++i) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Removing directory:" + removableDirs, this);
            }
            this.deleteSilently(removableDirs[i]);
        }
    }

    private void deleteSilently(File inDir) {
        block3: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("About to purge directory:" + inDir.getAbsolutePath(), this);
            }
            try {
                RecursiveDelete.delete(inDir);
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(this)) break block3;
                Logger.warn("Error purging directory", e, this);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryFileCache)) {
            return false;
        }
        DirectoryFileCache directoryFileCache = (DirectoryFileCache)o;
        if (!this.mFileMap.equals(directoryFileCache.mFileMap)) {
            return false;
        }
        return this.mRootDir.equals(directoryFileCache.mRootDir);
    }

    public int hashCode() {
        int result = this.mFileMap.hashCode();
        result = 29 * result + this.mRootDir.hashCode();
        return result;
    }

    public String toString() {
        return "DirectoryFileCache{mFileMap=" + this.mFileMap + ", mRootDir=" + this.mRootDir + "}";
    }

    private static class CachedDirDetails
    implements Serializable {
        private File mDir;
        private HashMap mFileTable = new HashMap();
        private transient HashSet mReferents;

        public CachedDirDetails(File inDir) {
            this.mDir = inDir;
        }

        public File getDir() {
            return this.mDir;
        }

        public boolean addReferent(Object referentKey) {
            return this.getReferentsSet().add(referentKey);
        }

        public boolean removeReferent(Object referentKey) {
            return this.getReferentsSet().remove(referentKey);
        }

        public boolean hasReferents() {
            return !this.getReferentsSet().isEmpty();
        }

        File checkoutFile(File file) {
            File original = (File)this.mFileTable.get(file.getName());
            if (original == null) {
                this.mFileTable.put(file.getName(), file);
            } else if (!original.equals(file)) {
                throw PackageInfo.createDuplicateName(file, original);
            }
            return new File(this.getDir(), file.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedDirDetails)) {
                return false;
            }
            CachedDirDetails cachedDirDetails = (CachedDirDetails)o;
            if (!this.mDir.equals(cachedDirDetails.mDir)) {
                return false;
            }
            return this.mFileTable.equals(cachedDirDetails.mFileTable);
        }

        public int hashCode() {
            int result = this.mDir.hashCode();
            result = 29 * result + this.mFileTable.hashCode();
            return result;
        }

        public String toString() {
            return "CachedDirDetails{mDir=" + this.mDir + ", mFileTable=" + this.mFileTable + "}";
        }

        private HashSet getReferentsSet() {
            if (this.mReferents == null) {
                this.mReferents = new HashSet();
            }
            return this.mReferents;
        }
    }
}

