/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.filecache;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.filecache.FileCache;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

class CachedFileSpec
implements Serializable {
    private long mLastModified;
    private long mLength;
    private File mCachedFile;
    private File mSourceFile;
    private transient int mLockCount;

    public CachedFileSpec(File sourceFile, FileCache fileCache) throws IOException {
        this.mSourceFile = sourceFile;
        this.mLastModified = sourceFile.lastModified();
        this.mLength = sourceFile.length();
        this.mCachedFile = File.createTempFile(fileCache.getFilePrefix(), fileCache.getFileSuffix(), fileCache.getCacheRootDir());
        CopyUtil.copyBinary(this.mSourceFile.toString(), this.mCachedFile.toString());
        this.mCachedFile.setReadOnly();
    }

    public long getLastModified() {
        return this.mLastModified;
    }

    public long getLength() {
        return this.mLength;
    }

    public File getCachedFile() {
        return this.mCachedFile;
    }

    public File getSourceFile() {
        return this.mSourceFile;
    }

    public boolean isSameFile(File file) {
        return this.getLength() == file.length() && this.getLastModified() == file.lastModified();
    }

    void addLock() {
        ++this.mLockCount;
    }

    void removeLock() {
        --this.mLockCount;
    }

    boolean isLocked() {
        return this.mLockCount > 0;
    }
}

