/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.iowrappers.AtomicOutput;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.iowrappers.OutputStreamWrapper;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    public static final char PATH_SEPARATOR = '/';

    private ZipUtil() {
    }

    private static void put(InputStream in, ZipEntry entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry);
        CopyUtil.copyBinary(in, out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(String in, ZipEntry entry, ZipOutputStream out) throws IOException {
        if (in == null) {
            return;
        }
        InputStreamWrapper inWrapper = new InputStreamWrapper(in);
        try {
            ZipUtil.put(inWrapper.getStream(), entry, out);
        }
        finally {
            inWrapper.close();
        }
    }

    public static boolean isZip(File file) {
        try {
            new ZipFile(file).close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZip(ZipFile zipFile, ZipEntry entry) {
        boolean bl;
        InputStream in = zipFile.getInputStream(entry);
        try {
            bl = new ZipInputStream(in).getNextEntry() != null;
        }
        catch (IOException ex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    return false;
                }
            }
            in.close();
            return bl2;
        }
        in.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZip(String zipName, String entryName) {
        try {
            ZipFile zipFile = new ZipFile(zipName);
            try {
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ZipUtil.isZip(zipFile, entry);
                return bl;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static String[] getDirectories(ZipFile zipFile) {
        HashSet<String> dirs = new HashSet<String>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            do {
                String[] dir = StringUtil.split(name, '/');
                name = dir[0];
                dirs.add(name);
            } while (name.length() > 0);
        }
        return (String[])CollectionUtil.mapClass(dirs, String;.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDirectories(String zipName) throws IOException {
        ZipFile zipFile = new ZipFile(zipName);
        try {
            String[] stringArray = ZipUtil.getDirectories(zipFile);
            return stringArray;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(ZipFile zipFile, ZipEntry entry, File out) throws IOException {
        Closer c = new Closer();
        try {
            InputStreamWrapper inWrapper = new InputStreamWrapper(zipFile.getInputStream(entry));
            c.register(inWrapper);
            OutputStreamWrapper outWrapper = new OutputStreamWrapper(out);
            c.register(outWrapper);
            CopyUtil.copyBinary(inWrapper.getStream(), outWrapper.getStream());
        }
        finally {
            c.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(String zipName, String entryName, String out) throws IOException {
        ZipFile zipFile = new ZipFile(zipName);
        try {
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                throw PackageInfo.createZipEntryNotFound(zipName, entryName);
            }
            ZipUtil.extract(zipFile, entry, new File(out));
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(String in, File zipFile, String entryName, boolean preservePerms) throws IOException {
        Closer c = new Closer();
        try {
            AtomicOutput out = null;
            out = preservePerms ? new AtomicOutput(zipFile, preservePerms) : new AtomicOutput(zipFile);
            c.register(out);
            OutputStreamWrapper outWrapper = new OutputStreamWrapper(out.getOutput());
            c.register(outWrapper);
            ZipOutputStream outZip = new ZipOutputStream(outWrapper.getStream());
            boolean found = false;
            if (zipFile.exists()) {
                ZipEntry entry;
                InputStreamWrapper zipWrapper = new InputStreamWrapper(zipFile);
                c.register(zipWrapper);
                ZipInputStream inZip = new ZipInputStream(zipWrapper.getStream());
                while ((entry = inZip.getNextEntry()) != null) {
                    try {
                        if (entryName.equals(entry.getName())) {
                            ZipUtil.put(in, new ZipEntry(entry), outZip);
                            found = true;
                            continue;
                        }
                        ZipUtil.put(inZip, entry, outZip);
                    }
                    finally {
                        inZip.closeEntry();
                    }
                }
            }
            if (!found) {
                ZipUtil.put(in, new ZipEntry(entryName), outZip);
            }
            outZip.finish();
            out.setValid(true);
        }
        finally {
            c.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDummy(File zipFile) throws IOException {
        OutputStreamWrapper outWrapper = new OutputStreamWrapper(zipFile);
        try {
            ZipOutputStream out = new ZipOutputStream(outWrapper.getStream());
            out.putNextEntry(new ZipEntry("DUMMY_DIRECTORY/"));
            out.closeEntry();
            out.finish();
        }
        finally {
            outWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(String in, String out) throws IOException {
        Closer c = new Closer();
        try {
            InputStreamWrapper inWrapper = new InputStreamWrapper(in);
            c.register(inWrapper);
            OutputStreamWrapper outWrapper = new OutputStreamWrapper(out);
            c.register(outWrapper);
            GZIPOutputStream outZip = new GZIPOutputStream(outWrapper.getStream());
            CopyUtil.copyBinary(inWrapper.getStream(), outZip);
            outZip.finish();
        }
        finally {
            c.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompress(String in, String out) throws IOException {
        Closer c = new Closer();
        try {
            InputStreamWrapper inWrapper = new InputStreamWrapper(in);
            c.register(inWrapper);
            OutputStreamWrapper outWrapper = new OutputStreamWrapper(out);
            c.register(outWrapper);
            CopyUtil.copyBinary(new GZIPInputStream(inWrapper.getStream()), outWrapper.getStream());
        }
        finally {
            c.closeAll();
        }
    }
}

