/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.PackageInfo;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XSLTUtil {
    private XSLTUtil() {
    }

    public static Transformer getTransformer(Source source) {
        try {
            return TransformerFactory.newInstance().newTransformer(source);
        }
        catch (TransformerConfigurationException ex) {
            throw PackageInfo.createBadTransformConfig(source, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transformer getTransformer(String source) {
        StringReader srcReader = new StringReader(source);
        try {
            Transformer transformer = XSLTUtil.getTransformer(new StreamSource(srcReader));
            return transformer;
        }
        finally {
            srcReader.close();
        }
    }

    public static Transformer getCopyTransformer() {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw PackageInfo.createBadTransformConfig(ex);
        }
    }

    public static void transform(Transformer transformer, Source source, Result result) {
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw PackageInfo.createTransformFailure(source, result, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transform(Transformer transformer, Source source) {
        StringWriter dstWriter = new StringWriter();
        try {
            XSLTUtil.transform(transformer, source, new StreamResult(dstWriter));
        }
        finally {
            try {
                dstWriter.close();
            }
            catch (IOException ex) {
                throw PackageInfo.createTransformFailure(source, (Exception)ex);
            }
        }
        return dstWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transform(Transformer transformer, String source) {
        StringReader srcReader = new StringReader(source);
        try {
            String string = XSLTUtil.transform(transformer, new StreamSource(srcReader));
            return string;
        }
        finally {
            srcReader.close();
        }
    }
}

