/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.file.CopyTransform;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.file.XSLTUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLTTransform
extends CopyTransform {
    private Transformer mTransformer;
    private XMLReader mReader;

    public XSLTTransform() {
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
    }

    public XSLTTransform(Source source, boolean ignoreDTD) {
        this();
        this.mTransformer = XSLTUtil.getTransformer(source);
        this.init(ignoreDTD);
    }

    public XSLTTransform(Source source) {
        this(source, true);
    }

    public XSLTTransform(Node node, boolean ignoreDTD) {
        this.mTransformer = XSLTUtil.getTransformer(XMLUtil.print(new DOMElementEnumeration(node).nextElement()));
        this.init(ignoreDTD);
    }

    public XSLTTransform(Node node) {
        this(node, true);
    }

    private void init(boolean ignoreDTD) {
        try {
            this.mReader = XMLReaderFactory.createXMLReader();
            if (ignoreDTD) {
                this.mReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
        }
        catch (SAXException ex) {
            throw PackageInfo.createBadParserConfig(ex);
        }
    }

    public void apply(Reader in, Writer out) throws IOException {
        if (this.mTransformer == null) {
            super.apply(in, out);
            return;
        }
        XSLTUtil.transform(this.mTransformer, new SAXSource(this.mReader, new InputSource(in)), new StreamResult(out));
    }
}

