/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.XSLTUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static DocumentBuilder getDocumentBuilder(boolean ignoreDTD) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (ignoreDTD) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
        }
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw PackageInfo.createBadParserConfig(ex);
        }
    }

    public static DocumentBuilder getDocumentBuilder() {
        return XMLUtil.getDocumentBuilder(false);
    }

    public static Document parse(DocumentBuilder documentBuilder, InputSource source) {
        try {
            return documentBuilder.parse(source);
        }
        catch (SAXException ex) {
            throw PackageInfo.createParsingFailure(source, (Exception)ex);
        }
        catch (IOException ex) {
            throw PackageInfo.createParsingFailure(source, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(DocumentBuilder documentBuilder, String source) {
        StringReader srcReader = new StringReader(source);
        try {
            Document document = XMLUtil.parse(documentBuilder, new InputSource(srcReader));
            return document;
        }
        finally {
            srcReader.close();
        }
    }

    public static Document parse(InputSource source, boolean ignoreDTD) {
        return XMLUtil.parse(XMLUtil.getDocumentBuilder(ignoreDTD), source);
    }

    public static Document parse(InputSource source) {
        return XMLUtil.parse(source, false);
    }

    public static Document parse(String source, boolean ignoreDTD) {
        return XMLUtil.parse(XMLUtil.getDocumentBuilder(ignoreDTD), source);
    }

    public static Document parse(String source) {
        return XMLUtil.parse(source, false);
    }

    public static void print(Node node, OutputStream output) {
        XSLTUtil.transform(XSLTUtil.getCopyTransformer(), new DOMSource(node), new StreamResult(output));
    }

    public static String print(Node node) {
        return XSLTUtil.transform(XSLTUtil.getCopyTransformer(), new DOMSource(node));
    }
}

