/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.CopyTransform;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.file.Transform;
import com.raplix.util.file.XSLTTransform;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class TransformFactory {
    public static final String TYPE_COPY = "COPY";
    public static final String TYPE_PERL = "PERL";
    public static final String TYPE_XSLT = "XSLT";

    private TransformFactory() {
    }

    public static Transform getEmptyTransform(String type) {
        if (TYPE_COPY.equals(type)) {
            return new CopyTransform();
        }
        if (TYPE_PERL.equals(type)) {
            return new Perl5Transform();
        }
        if (TYPE_XSLT.equals(type)) {
            return new XSLTTransform();
        }
        throw PackageInfo.createBadTransformType(type);
    }

    public static Transform getTransform(String type, Reader source) {
        if (TYPE_COPY.equals(type)) {
            return new CopyTransform();
        }
        if (TYPE_PERL.equals(type)) {
            return new Perl5Transform(new InputSource(source));
        }
        if (TYPE_XSLT.equals(type)) {
            return new XSLTTransform(new StreamSource(source));
        }
        throw PackageInfo.createBadTransformType(type);
    }

    public static Transform getTransform(String type, Node node) {
        if (TYPE_COPY.equals(type)) {
            return new CopyTransform();
        }
        if (TYPE_PERL.equals(type)) {
            return new Perl5Transform(node);
        }
        if (TYPE_XSLT.equals(type)) {
            return new XSLTTransform(node);
        }
        throw PackageInfo.createBadTransformType(type);
    }
}

