/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.FileInfo;
import com.raplix.util.file.Find;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.Visitor;
import com.raplix.util.file.VisitorBase;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Link;
import com.raplix.util.platform.windows.WindowsServices;
import com.raplix.util.platform.windows.WindowsServicesException;
import java.io.File;

public final class RecursiveDelete {
    private RecursiveDelete() {
    }

    public static void delete(File root) {
        Find.find(root, true, (Visitor)new Deleter());
    }

    public static void delete(String name) {
        RecursiveDelete.delete(new File(name));
    }

    private static class Deleter
    extends VisitorBase {
        private Deleter() {
        }

        public void visit(File file, int depth) {
            String cause;
            block8: {
                if (file.delete()) {
                    return;
                }
                cause = null;
                String path = file.getAbsolutePath();
                try {
                    if (PlatformUtil.isWin32()) {
                        cause = WindowsServices.getInstance().deleteFile(file);
                    }
                }
                catch (WindowsServicesException wse) {
                    throw new RuntimeException(wse);
                }
                if (PlatformUtil.isPOSIX()) {
                    try {
                        Link.del(path);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!Logger.isDebugEnabled(this)) break block8;
                        Logger.debug("Cannot delete: " + path, ex, this);
                    }
                }
            }
            if (new FileInfo(file).exists()) {
                throw PackageInfo.createCannotDelete(file, cause);
            }
        }
    }
}

