/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.Find;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.Visitor;
import com.raplix.util.file.VisitorBase;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.Chown;
import com.raplix.util.platform.posix.Group;
import com.raplix.util.platform.posix.Passwd;
import java.io.File;

public final class RecursiveChown {
    private RecursiveChown() {
    }

    public static void change(String root, long ownerID, long groupID, boolean recursive, boolean followLinks, boolean quitOnError) {
        ChownSetter s = new ChownSetter(ownerID, groupID, followLinks, quitOnError);
        if (recursive) {
            Find.find(root, (Visitor)s);
        } else {
            s.visit(new File(root), 0);
        }
    }

    public static void change(String root, String ownerName, String groupName, boolean recursive, boolean followLinks, boolean quitOnError) {
        long groupID;
        long ownerID;
        if (ownerName == null) {
            ownerID = -1L;
        } else {
            try {
                ownerID = Long.parseLong(ownerName.trim());
            }
            catch (NumberFormatException ex) {
                ownerID = new Passwd(ownerName).getUID();
            }
        }
        if (groupName == null) {
            groupID = -1L;
        } else {
            try {
                groupID = Long.parseLong(groupName.trim());
            }
            catch (NumberFormatException ex) {
                groupID = new Group(groupName).getGID();
            }
        }
        RecursiveChown.change(root, ownerID, groupID, recursive, followLinks, quitOnError);
    }

    public static void change(String root, long ownerID, long groupID, boolean recursive, boolean followLinks) {
        RecursiveChown.change(root, ownerID, groupID, recursive, followLinks, false);
    }

    public static void change(String root, String ownerName, String groupName, boolean recursive, boolean followLinks) {
        RecursiveChown.change(root, ownerName, groupName, recursive, followLinks, false);
    }

    private static class ChownSetter
    extends VisitorBase {
        private long mOwnerID;
        private long mGroupID;
        private boolean mFollowLinks;
        private boolean mQuitOnError;

        ChownSetter(long ownerID, long groupID, boolean followLinks, boolean quitOnError) {
            this.mOwnerID = ownerID;
            this.mGroupID = groupID;
            this.mFollowLinks = followLinks;
            this.mQuitOnError = quitOnError;
        }

        public void visit(File file, int depth) {
            block5: {
                try {
                    if (this.mFollowLinks) {
                        Chown.changeFile(file.getAbsolutePath(), this.mOwnerID, this.mGroupID);
                    } else {
                        Chown.changeLink(file.getAbsolutePath(), this.mOwnerID, this.mGroupID);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (this.mQuitOnError) {
                        throw ex;
                    }
                    if (!Logger.isWarnEnabled(this)) break block5;
                    Logger.warn(PackageInfo.createNoSetOwner(file, this.mOwnerID, this.mGroupID), ex, this);
                }
            }
        }
    }
}

