/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.Find;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.Visitor;
import com.raplix.util.file.VisitorBase;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.Chmod;
import java.io.File;

public final class RecursiveChmod {
    private RecursiveChmod() {
    }

    public static void change(String root, long mode, boolean recursive, boolean quitOnError) {
        ChmodSetter s = new ChmodSetter(mode, quitOnError);
        if (recursive) {
            Find.find(root, (Visitor)s);
        } else {
            s.visit(new File(root), 0);
        }
    }

    public static void change(String root, long mode, boolean recursive) {
        RecursiveChmod.change(root, mode, recursive, false);
    }

    private static class ChmodSetter
    extends VisitorBase {
        private long mMode;
        private boolean mQuitOnError;

        ChmodSetter(long mode, boolean quitOnError) {
            this.mMode = mode;
            this.mQuitOnError = quitOnError;
        }

        public void visit(File file, int depth) {
            block3: {
                try {
                    Chmod.change(file.getAbsolutePath(), this.mMode);
                }
                catch (IllegalArgumentException ex) {
                    if (this.mQuitOnError) {
                        throw ex;
                    }
                    if (!Logger.isWarnEnabled(this)) break block3;
                    Logger.warn(PackageInfo.createNoSetMode(file, this.mMode), ex, this);
                }
            }
        }
    }
}

