/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.file.CopyTransform;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Perl5Transform
extends CopyTransform {
    private Vector mSubs = new Vector();

    public Perl5Transform() {
    }

    public Perl5Transform(Node node) {
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        while (e.hasMoreElements()) {
            this.addSub(new Sub(e.nextElement()));
        }
    }

    public Perl5Transform(InputSource source) {
        this(XMLUtil.parse(source).getFirstChild());
    }

    public void addSub(Sub sub) {
        this.mSubs.addElement(sub);
    }

    public void apply(Reader in, Writer out) throws IOException {
        String line;
        if (this.mSubs.size() == 0) {
            super.apply(in, out);
            return;
        }
        BufferedReader inLine = new BufferedReader(in);
        PrintWriter outLine = new PrintWriter(out);
        while ((line = inLine.readLine()) != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Before: '" + line + "'", this);
            }
            Enumeration e = this.mSubs.elements();
            while (e.hasMoreElements()) {
                line = ((Sub)e.nextElement()).apply(line);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("After: '" + line + "'", this);
            }
            outLine.println(line);
        }
        outLine.flush();
    }

    public static class Sub {
        private static final String ATTR_PATTERN = "match";
        private static final String ATTR_SUBSTITUTION = "replace";
        private Pattern mPattern;
        private String mSubstitution;

        public Sub(String pattern, String substitution) {
            this.init(pattern, substitution);
        }

        Sub(Node node) {
            NamedNodeMap attr = node.getAttributes();
            this.init(attr.getNamedItem(ATTR_PATTERN).getNodeValue(), attr.getNamedItem(ATTR_SUBSTITUTION).getNodeValue());
        }

        private void init(String pattern, String substitution) {
            try {
                this.mPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException ex) {
                throw PackageInfo.createMalformedPattern(pattern, ex);
            }
            this.mSubstitution = substitution;
        }

        private String apply(String line) {
            return this.mPattern.matcher(line).replaceAll(this.mSubstitution);
        }
    }
}

