/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.DeleteException;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.xml.sax.InputSource;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.file";
    public static final String WARN_NO_RECURSE = "util.file.WARN_NO_RECURSE";
    public static final String WARN_NO_SET_MODE = "util.file.WARN_NO_SET_MODE";
    public static final String WARN_NO_SET_OWNER = "util.file.WARN_NO_SET_OWNER";
    public static final String EX_BAD_PARSER_CONFIGURATION = "util.file.EX_BAD_PARSER_CONFIGURATION";
    public static final String EX_BAD_TRANSFORMER_CONFIGURATION = "util.file.EX_BAD_TRANSFORMER_CONFIGURATION";
    public static final String EX_PARSING_FAILURE = "util.file.EX_PARSING_FAILURE";
    public static final String EX_TRANSFORM_FAILURE = "util.file.EX_TRANSFORM_FAILURE";
    public static final String EX_BAD_TRANSFORM_TYPE = "util.file.EX_BAD_TRANSFORM_TYPE";
    public static final String EX_MALFORMED_PATTERN = "util.file.EX_MALFORMED_PATTERN";
    public static final String EX_MISSING_ZIP_ENTRY = "util.file.EX_MISSING_ZIP_ENTRY";
    public static final String EX_CANNOT_DELETE = "util.file.EX_CANNOT_DELETE";
    public static final String EX_CANNOT_CREATE = "util.file.EX_CANNOT_CREATE";

    private PackageInfo() {
    }

    public static String createNoRecurse(File node) {
        return MessageManager.messageAsString(WARN_NO_RECURSE, new Object[]{node.getAbsolutePath()});
    }

    public static String createNoSetMode(File node, long mode) {
        return MessageManager.messageAsString(WARN_NO_SET_MODE, new Object[]{node.getAbsolutePath(), new Long(mode)});
    }

    public static String createNoSetOwner(File node, long ownerID, long groupID) {
        return MessageManager.messageAsString(WARN_NO_SET_OWNER, new Object[]{node.getAbsolutePath(), new Long(ownerID), new Long(groupID)});
    }

    public static IllegalArgumentException createBadParserConfig(Exception ex) {
        String message = MessageManager.messageAsString(EX_BAD_PARSER_CONFIGURATION, new Object[]{ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createBadTransformConfig(String source, Exception ex) {
        String message = MessageManager.messageAsString(EX_BAD_TRANSFORMER_CONFIGURATION, new Object[]{source, ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createBadTransformConfig(Source source, Exception ex) {
        return PackageInfo.createBadTransformConfig(source.getSystemId(), ex);
    }

    public static IllegalArgumentException createBadTransformConfig(Exception ex) {
        return PackageInfo.createBadTransformConfig("<Internal Copy Transformer>", ex);
    }

    public static IllegalArgumentException createParsingFailure(String source, Exception ex) {
        String message = MessageManager.messageAsString(EX_PARSING_FAILURE, new Object[]{source, ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createParsingFailure(InputSource source, Exception ex) {
        return PackageInfo.createParsingFailure(source.getSystemId(), ex);
    }

    public static IllegalArgumentException createTransformFailure(String source, String result, Exception ex) {
        String message = MessageManager.messageAsString(EX_TRANSFORM_FAILURE, new Object[]{source, result, ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createTransformFailure(String source, Exception ex) {
        return PackageInfo.createTransformFailure(source, "<String>", ex);
    }

    public static IllegalArgumentException createTransformFailure(Source source, Result result, Exception ex) {
        return PackageInfo.createTransformFailure(source.getSystemId(), result.getSystemId(), ex);
    }

    public static IllegalArgumentException createTransformFailure(Source source, Exception ex) {
        return PackageInfo.createTransformFailure(source.getSystemId(), ex);
    }

    public static IllegalArgumentException createBadTransformType(String type) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_BAD_TRANSFORM_TYPE, new Object[]{type}));
    }

    public static IllegalArgumentException createMalformedPattern(String pattern, Exception ex) {
        String message = MessageManager.messageAsString(EX_MALFORMED_PATTERN, new Object[]{pattern, ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createZipEntryNotFound(String zipName, String entryName) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_MISSING_ZIP_ENTRY, new Object[]{zipName, entryName}));
    }

    public static IOException createCannotDelete(File file, Exception ex) {
        return new IOException(MessageManager.messageAsString(EX_CANNOT_DELETE, new Object[]{file.getAbsolutePath(), ex.getMessage()}));
    }

    public static DeleteException createCannotDelete(File file, String cause) {
        return new DeleteException(MessageManager.messageAsString(EX_CANNOT_DELETE, new Object[]{file.getAbsolutePath(), cause}));
    }

    public static IOException createCannotCreate(File file) {
        return new IOException(MessageManager.messageAsString(EX_CANNOT_CREATE, new Object[]{file.getAbsolutePath()}));
    }
}

