/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.FileInfo;
import com.raplix.util.file.Visitor;
import java.io.File;

public final class Find {
    private Find() {
    }

    public static void find(File file, boolean childrenFirst, Visitor visitor) {
        new Finder(visitor, childrenFirst).apply(file, 0);
    }

    public static void find(String name, boolean childrenFirst, Visitor visitor) {
        Find.find(new File(name), childrenFirst, visitor);
    }

    public static void find(File file, Visitor visitor) {
        Find.find(file, false, visitor);
    }

    public static void find(String name, Visitor visitor) {
        Find.find(name, false, visitor);
    }

    private static class Finder {
        private Visitor mVisitor;
        private boolean mChildrenFirst;

        Finder(Visitor visitor, boolean childrenFirst) {
            this.mVisitor = visitor;
            this.mChildrenFirst = childrenFirst;
        }

        void apply(File file, int depth) {
            FileInfo info = new FileInfo(file);
            if (!info.exists()) {
                return;
            }
            if (this.mVisitor.shouldPrune(file, depth)) {
                return;
            }
            if (!this.mChildrenFirst) {
                this.mVisitor.visit(file, depth);
            }
            if (info.isDirectory()) {
                File[] f = file.listFiles();
                if (f == null) {
                    this.mVisitor.cannotRecurse(file, depth);
                    return;
                }
                for (int i = 0; i < f.length; ++i) {
                    this.apply(f[i], depth + 1);
                }
            }
            if (this.mChildrenFirst) {
                this.mVisitor.visit(file, depth);
            }
        }
    }
}

