/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.file.DeleteException;
import com.raplix.util.file.FileInfo;
import com.raplix.util.file.PackageInfo;
import com.raplix.util.file.RecursiveDelete;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public final class FileUtil {
    public static final Comparator FILE_SORT_ALPHA = new Comparator(){

        public int compare(Object o1, Object o2) {
            return StringUtil.compareDictionary(((File)o1).getName(), ((File)o2).getName());
        }
    };

    private FileUtil() {
    }

    public static void ensureDeleted(File file) throws IOException {
        try {
            RecursiveDelete.delete(file);
        }
        catch (DeleteException ex) {
            throw PackageInfo.createCannotDelete(file, ex);
        }
    }

    public static void ensureDeleted(String file) throws IOException {
        FileUtil.ensureDeleted(new File(file));
    }

    public static void ensurePlainPresent(File file) throws IOException {
        FileInfo info = new FileInfo(file);
        if (info.exists() ? info.isPlain() : file.createNewFile()) {
            return;
        }
        throw PackageInfo.createCannotCreate(file);
    }

    public static void ensurePlainPresent(String file) throws IOException {
        FileUtil.ensurePlainPresent(new File(file));
    }

    public static void ensureDirPresent(File file) throws IOException {
        FileInfo info = new FileInfo(file);
        if (info.exists() ? info.isDirectory() : file.mkdir()) {
            return;
        }
        throw PackageInfo.createCannotCreate(file);
    }

    public static void ensureDirPresent(String file) throws IOException {
        FileUtil.ensureDirPresent(new File(file));
    }

    private static ArrayList buildPath(File inFile) {
        String filePath = inFile.getAbsolutePath();
        StringBuffer currentPath = new StringBuffer();
        ArrayList<PathElement> pathElementList = new ArrayList<PathElement>();
        String[] pathElements = filePath.split(File.separator);
        for (int i = 1; i < pathElements.length; ++i) {
            currentPath.append(File.separator + pathElements[i]);
            if (!pathElements[i].equals(".") && !pathElements[i].equals("..")) {
                FileInfo fileInfo = new FileInfo(currentPath.toString());
                pathElementList.add(new PathElement(pathElements[i], fileInfo.isLink()));
                continue;
            }
            pathElementList.add(new PathElement(pathElements[i], false));
        }
        return pathElementList;
    }

    public static File getAbsoluteNormalizedFile(File inFile) throws IOException {
        PathElement lastElement = null;
        LinkedList<PathElement> outputStack = new LinkedList<PathElement>();
        ListIterator outputIter = null;
        if (!inFile.exists()) {
            throw new IllegalArgumentException(inFile.getPath() + " does not exist");
        }
        if (!PlatformUtil.isPOSIX()) {
            return inFile.getCanonicalFile();
        }
        ArrayList pathElementList = FileUtil.buildPath(inFile);
        for (int i = 0; i < pathElementList.size(); ++i) {
            PathElement currentElement = (PathElement)pathElementList.get(i);
            if (currentElement.isCurrentLinkElement()) continue;
            if (currentElement.isParentLinkElement() && lastElement != null) {
                if (lastElement.isLink() || lastElement.isParentLinkElement()) {
                    outputStack.add(currentElement);
                    lastElement = currentElement;
                    continue;
                }
                outputStack.removeLast();
                lastElement = (PathElement)outputStack.getLast();
                continue;
            }
            if (currentElement.isParentLinkElement()) continue;
            outputStack.add(currentElement);
            lastElement = currentElement;
        }
        StringBuffer filePath = new StringBuffer(File.separator);
        outputIter = outputStack.listIterator(0);
        while (outputIter.hasNext()) {
            filePath.append(((PathElement)outputIter.next()).getName());
            if (!outputIter.hasNext()) continue;
            filePath.append(File.separator);
        }
        return new File(filePath.toString());
    }

    private static class PathElement {
        private String name;
        private boolean linkFlag;

        public PathElement(String name, boolean isLink) {
            this.name = name;
            this.linkFlag = isLink;
        }

        public boolean isLink() {
            return this.linkFlag;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCurrentLinkElement() {
            return this.name.equals(".");
        }

        public boolean isParentLinkElement() {
            return this.name.equals("..");
        }
    }
}

