/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;

public class FileInfo {
    private static final int TYPE_UNKNOWN = -2;
    public static final int TYPE_NONEXISTENT = -1;
    public static final int TYPE_OTHER = 0;
    public static final int TYPE_BLOCK_SPECIAL = 1;
    public static final int TYPE_CHARACTER_SPECIAL = 2;
    public static final int TYPE_FIFO_SPECIAL = 4;
    public static final int TYPE_LINK = 6;
    public static final int TYPE_DIRECTORY = 3;
    public static final int TYPE_PLAIN = 5;
    private File mFile;
    private int mType = -2;
    private Object mLock = new Object();

    public FileInfo(File file) {
        this.mFile = file;
    }

    public FileInfo(String file) {
        this(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadType() {
        if (this.mType != -2) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mType != -2) {
                return;
            }
            if (PlatformUtil.isPOSIX()) {
                Stat s;
                try {
                    s = new Stat(this.mFile.getAbsolutePath());
                }
                catch (IllegalArgumentException ex) {
                    this.mType = -1;
                    return;
                }
                if (s.isBlockSpecial()) {
                    this.mType = 1;
                    return;
                }
                if (s.isCharacterSpecial()) {
                    this.mType = 2;
                    return;
                }
                if (s.isDirectory()) {
                    this.mType = 3;
                    return;
                }
                if (s.isFIFOSpecial()) {
                    this.mType = 4;
                    return;
                }
                if (s.isRegular()) {
                    this.mType = 5;
                    return;
                }
                if (s.isLink()) {
                    this.mType = 6;
                    return;
                }
            } else {
                if (!this.mFile.exists()) {
                    this.mType = -1;
                    return;
                }
                if (this.mFile.isDirectory()) {
                    this.mType = 3;
                    return;
                }
                if (this.mFile.isFile()) {
                    this.mType = 5;
                    return;
                }
            }
            this.mType = 0;
        }
    }

    public File getFile() {
        return this.mFile;
    }

    public int getType() {
        this.loadType();
        return this.mType;
    }

    public boolean exists() {
        return this.getType() != -1;
    }

    public boolean isLink() {
        return this.getType() == 6;
    }

    public boolean isDirectory() {
        return this.getType() == 3;
    }

    public boolean isPlain() {
        return this.getType() == 5;
    }
}

