/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.file;

import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.iowrappers.OutputStreamWrapper;
import com.raplix.util.iowrappers.ReaderWrapper;
import com.raplix.util.iowrappers.WriterWrapper;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Chmod;
import com.raplix.util.platform.posix.Stat;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class CopyUtil {
    private static final int BUFFER_SIZE = 32768;

    private CopyUtil() {
    }

    public static void copyBinary(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[32768];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    public static void copyText(Reader in, Writer out) throws IOException {
        int count;
        char[] buffer = new char[32768];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBinary(String in, String out) throws IOException {
        Closer c = new Closer();
        try {
            InputStreamWrapper inWrp = new InputStreamWrapper(in);
            c.register(inWrp);
            OutputStreamWrapper outWrp = new OutputStreamWrapper(out);
            c.register(outWrp);
            CopyUtil.copyBinary(inWrp.getStream(), outWrp.getStream());
        }
        finally {
            c.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyText(String in, String out) throws IOException {
        Closer c = new Closer();
        try {
            ReaderWrapper inWrp = new ReaderWrapper(in);
            c.register(inWrp);
            WriterWrapper outWrp = new WriterWrapper(out);
            c.register(outWrp);
            CopyUtil.copyText(inWrp.getReader(), outWrp.getWriter());
        }
        finally {
            c.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinary(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            CopyUtil.copyBinary(in, out);
        }
        finally {
            out.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinary(String name) throws IOException {
        InputStreamWrapper inWrp = new InputStreamWrapper(name);
        try {
            byte[] byArray = CopyUtil.readBinary(inWrp.getStream());
            return byArray;
        }
        finally {
            inWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readText(Reader in) throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        try {
            CopyUtil.copyText(in, out);
        }
        finally {
            out.close();
        }
        return out.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readText(String name) throws IOException {
        ReaderWrapper inWrp = new ReaderWrapper(name);
        try {
            char[] cArray = CopyUtil.readText(inWrp.getReader());
            return cArray;
        }
        finally {
            inWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readTextSkipNewlines(String name) throws IOException {
        ReaderWrapper inWrp = new ReaderWrapper(name);
        try {
            char[] cArray = CopyUtil.readTextSkipNewlines(inWrp.getReader());
            return cArray;
        }
        finally {
            inWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readTextSkipNewlines(Reader reader) throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        BufferedReader in = new BufferedReader(reader);
        try {
            CopyUtil.copyTextSkipNewlines(in, out);
        }
        finally {
            out.close();
        }
        return out.toCharArray();
    }

    public static void copyTextSkipNewlines(BufferedReader inIn, Writer inOut) throws IOException {
        String line;
        while ((line = inIn.readLine()) != null) {
            inOut.write(line, 0, line.length());
        }
        inOut.flush();
    }

    public static Object readObject(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = new ObjectInputStream(in);
        return oin.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(String name) throws IOException, ClassNotFoundException {
        InputStreamWrapper inWrp = new InputStreamWrapper(name);
        try {
            Object object = CopyUtil.readObject(inWrp.getStream());
            return object;
        }
        finally {
            inWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinary(byte[] data, String name) throws IOException {
        OutputStreamWrapper outWrp = new OutputStreamWrapper(name);
        try {
            outWrp.getStream().write(data);
        }
        finally {
            outWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(char[] data, String name) throws IOException {
        WriterWrapper outWrp = new WriterWrapper(name);
        try {
            outWrp.getWriter().write(data);
        }
        finally {
            outWrp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object data, String name) throws IOException {
        OutputStreamWrapper outWrp = new OutputStreamWrapper(name);
        try {
            CopyUtil.writeObject(data, outWrp.getStream());
        }
        finally {
            outWrp.close();
        }
    }

    public static void writeObject(Object data, OutputStream out) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(data);
        objOut.flush();
    }

    public static void copyPermissions(File source, File target) throws IllegalArgumentException {
        if (PlatformUtil.isPOSIX()) {
            Stat stat = new Stat(source.getAbsolutePath());
            long mask = Stat.RWXU | Stat.RWXG | Stat.RWXO;
            Chmod.change(target.getAbsolutePath(), stat.getMode() & mask);
        }
    }
}

