/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.executor;

import com.raplix.util.executor.HelperContext;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.iowrappers.OutputStreamWrapper;
import com.raplix.util.threads.Context;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamContext
extends HelperContext {
    private Closer mCloser = new Closer();
    private InputStream mInput;
    private OutputStream mOutput;

    public StreamContext(String name, Context parent, InputStream input, boolean closeInput, OutputStream output, boolean closeOutput) {
        super(name, parent);
        if (input != null) {
            this.mInput = input;
            if (closeInput) {
                this.mCloser.register(new InputStreamWrapper(this.mInput));
            }
        }
        if (output != null) {
            this.mOutput = output;
            if (closeOutput) {
                this.mCloser.register(new OutputStreamWrapper(this.mOutput));
            }
        }
    }

    public void release() throws Exception {
        super.release();
        this.mCloser.closeAll();
    }

    protected void safeRun() throws Exception {
        if (this.mInput != null && this.mOutput != null) {
            CopyUtil.copyBinary(this.mInput, this.mOutput);
        }
    }

    public InputStream getInputStream() {
        return this.mInput;
    }

    public OutputStream getOutputStream() {
        return this.mOutput;
    }
}

