/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.executor;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.executor.ByteOutputConsumer;
import com.raplix.util.executor.Exec;
import com.raplix.util.executor.PackageInfo;
import com.raplix.util.logger.Logger;

public class RunMain {
    public static void main(String[] args) {
        Logger.initializeLoggingSystem();
        try {
            RunMain.run(args);
        }
        catch (Throwable t) {
            if (Logger.isErrorEnabled(RunMain.class)) {
                Logger.error("Execution failed", t, RunMain.class);
            }
            System.exit(1);
        }
    }

    private static void run(String[] args) {
        int cmdArgCount;
        String loggerFile = null;
        long loggerDelay = 0L;
        int cmdStart = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-h".equals(args[i]) || "-help".equals(args[i])) {
                System.out.println("Usage:");
                System.out.println();
                System.out.println("-h|-help: shows usage info [no]");
                System.out.println("-lc <file name>: logger configuration file");
                System.out.println("-ld <seconds>: logger file watch delay");
                System.out.println("-cmd <...>: command to execute with arguments");
                System.out.println();
                System.out.println("No switches is same as -cmd <...>");
                return;
            }
            if ("-lc".equals(args[i])) {
                if (++i == args.length) {
                    if (Logger.isErrorEnabled(class$com$raplix$util$executor$RunMain == null ? RunMain.class$("com.raplix.util.executor.RunMain") : class$com$raplix$util$executor$RunMain)) {
                        Logger.error("Missing logger file", class$com$raplix$util$executor$RunMain == null ? RunMain.class$("com.raplix.util.executor.RunMain") : class$com$raplix$util$executor$RunMain);
                    }
                    System.exit(1);
                }
                loggerFile = args[i];
                continue;
            }
            if ("-ld".equals(args[i])) {
                if (++i == args.length) {
                    if (Logger.isErrorEnabled(class$com$raplix$util$executor$RunMain == null ? RunMain.class$("com.raplix.util.executor.RunMain") : class$com$raplix$util$executor$RunMain)) {
                        Logger.error("Missing logger delay", class$com$raplix$util$executor$RunMain == null ? RunMain.class$("com.raplix.util.executor.RunMain") : class$com$raplix$util$executor$RunMain);
                    }
                    System.exit(1);
                }
                loggerDelay = Long.parseLong(args[i]);
                continue;
            }
            if (!"-cmd".equals(args[i])) break;
            cmdStart = i + 1;
            break;
        }
        if (loggerFile != null) {
            Logger.initializeLoggingSystem(loggerFile, loggerDelay);
        }
        if ((cmdArgCount = args.length - cmdStart) == 0) {
            if (Logger.isErrorEnabled(RunMain.class)) {
                Logger.error("Missing command", RunMain.class);
            }
            System.exit(1);
        }
        String[] cmdArgs = cmdStart == 0 ? args : (String[])CollectionUtil.sliceClass(args, String;.class, cmdStart, CollectionUtil.LAST_INDEX);
        String cmd = CollectionUtil.toString(cmdArgs);
        Exec e = null;
        try {
            e = new Exec(cmdArgs, null, -1L, -1L);
        }
        catch (Exception ex) {
            if (Logger.isErrorEnabled(RunMain.class)) {
                Logger.error("Cannot execute: \"" + cmd + "\"", ex, RunMain.class);
            }
            System.exit(1);
        }
        int code = e.getExecutionThread().getExitCode();
        if (Logger.isErrorEnabled(RunMain.class) && code != 0) {
            Logger.error(PackageInfo.createExecFailed(cmd, code, ((ByteOutputConsumer)e.getStdoutThread()).getOutput(), ((ByteOutputConsumer)e.getStderrThread()).getOutput()), RunMain.class);
        }
    }
}

