/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.executor;

import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.executor.ByteOutputConsumer;
import com.raplix.util.executor.Exec;
import com.raplix.util.executor.PackageInfo;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;

public final class ExecUtil {
    public static final String[] JAVAC_PREFIX = new String[]{System.getProperty("java.home") + File.separator + ".." + File.separator + "bin" + File.separator + "javac", "-classpath", System.getProperty("java.class.path")};
    public static final String JAVAC_PREFIX_FLAT = CollectionUtil.toString(JAVAC_PREFIX, "", " ");
    public static final String[] JAVA_PREFIX = new String[]{System.getProperty("java.home") + File.separator + "bin" + File.separator + "java", "-classpath", System.getProperty("java.class.path")};
    public static final String JAVA_PREFIX_FLAT = CollectionUtil.toString(JAVA_PREFIX, "", " ");

    private ExecUtil() {
    }

    private static Exec runJVM(String prefix, String[] classpath, String arg) throws IOException, InterruptedException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        if (classpath != null) {
            String s = System.getProperty("path.separator");
            for (int i = 0; i < classpath.length; ++i) {
                buffer.append(s);
                buffer.append(classpath[i]);
            }
        }
        buffer.append(' ');
        buffer.append(arg);
        return ExecUtil.run(buffer.toString());
    }

    public static Exec run(String command) throws IOException, InterruptedException {
        Exec e = new Exec(command, null, -1L, -1L);
        int code = e.getExecutionThread().getExitCode();
        if (Logger.isErrorEnabled(ExecUtil.class) && code != 0) {
            Logger.error(PackageInfo.createExecFailed(command, code, ((ByteOutputConsumer)e.getStdoutThread()).getOutput(), ((ByteOutputConsumer)e.getStderrThread()).getOutput()), ExecUtil.class);
        }
        return e;
    }

    public static Exec run(String[] command) throws IOException, InterruptedException {
        Exec e = new Exec(command, null, -1L, -1L);
        int code = e.getExecutionThread().getExitCode();
        if (Logger.isErrorEnabled(ExecUtil.class) && code != 0) {
            Logger.error(PackageInfo.createExecFailed(Util.getStringFromArray(command, " "), code, ((ByteOutputConsumer)e.getStdoutThread()).getOutput(), ((ByteOutputConsumer)e.getStderrThread()).getOutput()), ExecUtil.class);
        }
        return e;
    }

    public static Exec compileJava(String[] classpath, String arg) throws IOException, InterruptedException {
        return ExecUtil.runJVM(JAVAC_PREFIX_FLAT, classpath, arg);
    }

    public static Exec runJava(String[] classpath, String arg) throws IOException, InterruptedException {
        return ExecUtil.runJVM(JAVA_PREFIX_FLAT, classpath, arg);
    }
}

