/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.executor;

import com.raplix.util.executor.ByteInputSupplier;
import com.raplix.util.executor.ByteOutputConsumer;
import com.raplix.util.executor.ExitConsumer;
import com.raplix.util.executor.HelperContext;
import com.raplix.util.executor.InputSupplier;
import com.raplix.util.executor.OutputConsumer;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.ContextTimeoutMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Exec {
    private static final long QUANTUM = 1000L;
    public static final long TIMEOUT_INDEFINITE = -1L;
    public static final long TIMEOUT_BACKGROUND = -2L;
    public static final long TIMEOUT_REMAINING = -3L;
    private InputSupplier mStdin;
    private OutputConsumer mStdout;
    private OutputConsumer mStderr;
    private ExitConsumer mExit;

    public Exec(String command, byte[] input, long execTimeout, long streamTimeout) throws IOException, InterruptedException {
        this(Runtime.getRuntime().exec(command), input, execTimeout, streamTimeout);
    }

    public Exec(String[] command, byte[] input, long execTimeout, long streamTimeout) throws IOException, InterruptedException {
        this(Runtime.getRuntime().exec(command), input, execTimeout, streamTimeout);
    }

    public Exec(Process process, byte[] input, long execTimeout, long streamTimeout) throws InterruptedException {
        Context global = new Context(Exec.class.getName());
        this.init(process, global, new ByteInputSupplier(global, process, input), new ByteOutputConsumer(global, process, true), new ByteOutputConsumer(global, process, false), execTimeout, streamTimeout);
    }

    public Exec(Process process, InputStream stdin, OutputStream stdout, OutputStream stderr, boolean closeStd, long execTimeout, long streamTimeout) throws InterruptedException {
        Context global = new Context(Exec.class.getName());
        this.init(process, global, new InputSupplier(global, process, stdin, closeStd), new OutputConsumer(global, process, true, stdout, closeStd), new OutputConsumer(global, process, false, stderr, closeStd), execTimeout, streamTimeout);
    }

    public Exec(Process process, InputStream stdin, OutputStream stdout, OutputStream stderr, long execTimeout, long streamTimeout) throws InterruptedException {
        this(process, stdin, stdout, stderr, true, execTimeout, streamTimeout);
    }

    private void init(Process process, Context context, InputSupplier stdin, OutputConsumer stdout, OutputConsumer stderr, long execTimeout, long streamTimeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        this.mStdin = stdin;
        ContextThread tStdin = Exec.startHelper(this.mStdin, streamTimeout);
        this.mStdout = stdout;
        ContextThread tStdout = Exec.startHelper(this.mStdout, streamTimeout);
        this.mStderr = stderr;
        ContextThread tStderr = Exec.startHelper(this.mStderr, streamTimeout);
        this.mExit = new ExitConsumer("exit", context, process);
        ContextThread tExit = Exec.startHelper(this.mExit, execTimeout);
        if (execTimeout != -2L) {
            ContextTimeoutMonitor monExit = new ContextTimeoutMonitor();
            monExit.addThread(tExit);
            if (execTimeout != -1L) {
                monExit.monitor(execTimeout, 1000L);
            }
            monExit.join();
        }
        ProcessDestroyMonitor monStream = null;
        if (streamTimeout != -2L) {
            if (streamTimeout == -3L) {
                streamTimeout = Math.max(0L, execTimeout - (System.currentTimeMillis() - startTime));
            }
            monStream = new ProcessDestroyMonitor(process);
            monStream.addThread(tStdin);
            monStream.addThread(tStdout);
            monStream.addThread(tStderr);
            if (streamTimeout != -1L) {
                monStream.monitor(streamTimeout, 1000L);
            }
            monStream.join();
        }
        if (execTimeout != -2L && monStream != null && !monStream.isProcessDestroyed()) {
            process.destroy();
        }
    }

    private static ContextThread startHelper(HelperContext context, long timeout) {
        ContextThread t = new ContextThread(context);
        if (timeout == -2L) {
            t.setDaemon(true);
        }
        t.start();
        return t;
    }

    public InputSupplier getStdinThread() {
        return this.mStdin;
    }

    public OutputConsumer getStdoutThread() {
        return this.mStdout;
    }

    public OutputConsumer getStderrThread() {
        return this.mStderr;
    }

    public ExitConsumer getExecutionThread() {
        return this.mExit;
    }

    public boolean isTimedOut() {
        return this.getStdinThread().isTimedOut() || this.getStdoutThread().isTimedOut() || this.getStderrThread().isTimedOut() || this.getExecutionThread().isTimedOut();
    }

    public int getExitCode() {
        return this.getExecutionThread().getExitCode();
    }

    private static class ProcessDestroyMonitor
    extends ContextTimeoutMonitor {
        private Process mProcess;
        private boolean mIsDestroyed = false;

        ProcessDestroyMonitor(Process process) {
            this.mProcess = process;
        }

        protected void stopThread(Thread thread) {
            this.mProcess.destroy();
            this.mIsDestroyed = true;
            super.stopThread(thread);
        }

        boolean isProcessDestroyed() {
            return this.mIsDestroyed;
        }
    }
}

