/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.exceptions;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static void rethrow(Throwable t) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static void unwrap(InvocationTargetException ex) throws Exception {
        Throwable t = ex.getTargetException();
        ExceptionUtil.rethrow(t);
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try {
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
            }
            finally {
                pw.close();
            }
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException iOException) {}
        }
        return sw.toString();
    }
}

