/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class TypedSet
extends AbstractSet
implements RPCSerializable,
Cloneable {
    private Hashtable mElementMap = new Hashtable();
    private Vector mElements = new Vector();

    protected TypedSet() {
    }

    public Iterator iterator() {
        final Iterator iter = this.mElements.iterator();
        return new Iterator(){
            Object mLastObj = null;

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                this.mLastObj = null;
                this.mLastObj = iter.next();
                return this.mLastObj;
            }

            public void remove() {
                if (this.mLastObj == null) {
                    throw new IllegalStateException();
                }
                Object lastObj = this.mLastObj;
                this.mLastObj = null;
                iter.remove();
                TypedSet.this.mElementMap.remove(lastObj);
            }
        };
    }

    public int size() {
        return this.mElements.size();
    }

    public boolean contains(Object element) {
        return this.mElementMap.containsKey(element);
    }

    public abstract Object[] toArray();

    public Object[] toArray(Object[] arr) {
        return this.mElements.toArray(arr);
    }

    public boolean add(Object element) {
        if (this.mElementMap.containsKey(element)) {
            return false;
        }
        this.checkElement(element);
        this.addElement(element);
        return true;
    }

    private void addElement(Object element) {
        if (this.mElementMap.put(element, element) == null) {
            this.mElements.add(element);
        }
    }

    public boolean remove(Object element) {
        if (this.mElementMap.remove(element) != null) {
            this.mElements.remove(element);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        ArrayList additions = new ArrayList(cSize);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (this.mElementMap.containsKey(elem)) continue;
            this.checkElement(elem);
            additions.add(elem);
        }
        int aSize = additions.size();
        if (aSize == 0) {
            return false;
        }
        int mySize = this.mElements.size();
        this.mElements.ensureCapacity(mySize + aSize);
        it = additions.iterator();
        while (it.hasNext()) {
            this.addElement(it.next());
        }
        return true;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.mElements.clear();
            this.mElementMap.clear();
        }
    }

    public Object clone() {
        try {
            TypedSet result = (TypedSet)super.clone();
            result.mElements = (Vector)this.mElements.clone();
            result.mElementMap = (Hashtable)this.mElementMap.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected abstract void checkElement(Object var1);
}

