/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class TypedList
extends AbstractList
implements RPCSerializable,
Cloneable {
    private Vector mContainer = new Vector();

    protected TypedList() {
    }

    private List getContainer() {
        return this.mContainer;
    }

    public Object get(int index) {
        return this.getContainer().get(index);
    }

    public int size() {
        return this.getContainer().size();
    }

    public Object set(int index, Object element) {
        this.checkElement(element);
        return this.getContainer().set(index, element);
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.checkElement(element);
        ++this.modCount;
        this.getContainer().add(index, element);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ++this.modCount;
        return this.getContainer().remove(index);
    }

    public abstract Object[] toArray();

    public Object[] toArray(Object[] arr) {
        return this.getContainer().toArray(arr);
    }

    protected void removeRange(int fromIndex, int toIndex) {
        List subList = this.getContainer().subList(fromIndex, toIndex);
        if (subList.size() > 0) {
            ++this.modCount;
            subList.clear();
        }
    }

    public boolean addAll(int index, Collection c) {
        Iterator it = c.iterator();
        boolean hasElems = false;
        while (it.hasNext()) {
            hasElems = true;
            this.checkElement(it.next());
        }
        if (hasElems) {
            ++this.modCount;
            return this.getContainer().addAll(index, c);
        }
        return false;
    }

    public void swap(int n1, int n2) {
        this.set(n1, this.set(n2, this.get(n1)));
    }

    public Object clone() {
        try {
            TypedList result = (TypedList)super.clone();
            result.mContainer = (Vector)this.mContainer.clone();
            result.modCount = 0;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected abstract void checkElement(Object var1);
}

