/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import com.raplix.util.collections.TypedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class TypedHashList
extends TypedList {
    private Hashtable mElemMap = new Hashtable();

    protected TypedHashList() {
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.mElemMap.containsKey(key);
    }

    public Object getByKey(Object key) {
        if (key == null) {
            return null;
        }
        return this.mElemMap.get(key);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.mElemMap.keySet());
    }

    public void add(int index, Object element) {
        Object key = this.getKey(element);
        if (this.containsKey(key)) {
            throw this.getDuplicateElementError(key);
        }
        super.add(index, element);
        this.mElemMap.put(key, element);
    }

    public Object set(int index, Object element) {
        Object key = this.getKey(element);
        Object curKey = this.getKey(this.get(index));
        if (!curKey.equals(key) && this.containsKey(key)) {
            throw this.getDuplicateElementError(key);
        }
        Object result = super.set(index, element);
        this.mElemMap.remove(curKey);
        this.mElemMap.put(key, element);
        return result;
    }

    public void swap(int n1, int n2) {
        super.set(n1, super.set(n2, this.get(n1)));
    }

    public boolean addAll(int index, Collection c) {
        Hashtable locals = new Hashtable(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Object key = this.getKey(element);
            if (this.containsKey(key)) {
                throw this.getDuplicateElementError(key);
            }
            if (locals.put(key, element) == null) continue;
            throw this.getDuplicateElementError(key);
        }
        boolean result = super.addAll(index, c);
        this.mElemMap.putAll(locals);
        return result;
    }

    public Object remove(int index) {
        Object element = super.remove(index);
        this.mElemMap.remove(this.getKey(element));
        return element;
    }

    public void clear() {
        super.clear();
        this.mElemMap.clear();
    }

    public Object clone() {
        TypedHashList result = (TypedHashList)super.clone();
        result.mElemMap = (Hashtable)result.mElemMap.clone();
        return result;
    }

    protected abstract Object getKey(Object var1);

    protected RuntimeException getDuplicateElementError(Object key) {
        return new IllegalArgumentException("key exists: " + key);
    }
}

