/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeCollection
extends AbstractCollection {
    private TreeMap mMetaData;
    private TreeSet mNodes = new TreeSet();

    public TreeCollection() {
        this.mMetaData = new TreeMap();
    }

    public TreeCollection(Collection c) {
        this.mMetaData = new TreeMap();
        this.addAll(c);
    }

    public TreeCollection(Comparator c) {
        this.mMetaData = new TreeMap(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        TreeMap treeMap = this.mMetaData;
        synchronized (treeMap) {
            MetaData m = (MetaData)this.mMetaData.get(o);
            if (m == null) {
                m = new MetaData();
                this.mMetaData.put(o, m);
            }
            return this.mNodes.add(new Node(o, m.add()));
        }
    }

    public Iterator iterator() {
        return new TreeIterator();
    }

    public int size() {
        return this.mNodes.size();
    }

    public int distinctSize() {
        return this.mMetaData.size();
    }

    public Object first() {
        return ((Node)this.mNodes.first()).getData();
    }

    public Object last() {
        return ((Node)this.mNodes.last()).getData();
    }

    private class TreeIterator
    implements Iterator {
        private Iterator mNodesIterator;
        private Object mLast;

        TreeIterator() {
            this.mNodesIterator = TreeCollection.this.mNodes.iterator();
        }

        public boolean hasNext() {
            return this.mNodesIterator.hasNext();
        }

        public Object next() {
            this.mLast = ((Node)this.mNodesIterator.next()).getData();
            return this.mLast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            TreeMap treeMap = TreeCollection.this.mMetaData;
            synchronized (treeMap) {
                if (((MetaData)TreeCollection.this.mMetaData.get(this.mLast)).remove()) {
                    TreeCollection.this.mMetaData.remove(this.mLast);
                }
                this.mNodesIterator.remove();
            }
        }
    }

    private static class MetaData {
        private int mNext;
        private int mCount;

        private MetaData() {
        }

        int add() {
            ++this.mCount;
            return this.mNext++;
        }

        boolean remove() {
            --this.mCount;
            return this.mCount == 0;
        }
    }

    private class Node
    implements Comparable {
        private Object mData;
        private int mArbitrer;

        Node(Object data, int arbitrer) {
            this.mData = data;
            this.mArbitrer = arbitrer;
        }

        Object getData() {
            return this.mData;
        }

        int getArbitrer() {
            return this.mArbitrer;
        }

        public int compareTo(Object o) {
            Node n = (Node)o;
            Comparator c = TreeCollection.this.mMetaData.comparator();
            int result = c != null ? c.compare(this.getData(), n.getData()) : ((Comparable)this.getData()).compareTo(n.getData());
            if (result != 0) {
                return result;
            }
            return this.getArbitrer() - n.getArbitrer();
        }
    }
}

