/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import java.util.Comparator;
import java.util.Vector;

public class PriorityQueue {
    private Vector mNodes = new Vector();
    private Comparator mComparator = null;

    public PriorityQueue() {
    }

    public PriorityQueue(Comparator comparator) {
        this.mComparator = comparator;
    }

    private int compare(Object o1, Object o2) {
        if (this.mComparator != null) {
            return this.mComparator.compare(o1, o2);
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public synchronized void add(Object o) {
        int parent;
        this.mNodes.add(o);
        int i = this.mNodes.size() - 1;
        while (i != 0 && this.compare(this.mNodes.get(parent = i / 2), o) < 0) {
            this.mNodes.set(i, this.mNodes.get(parent));
            i = parent;
        }
        this.mNodes.set(i, o);
    }

    public Object getMax() {
        return this.mNodes.get(0);
    }

    public synchronized Object extractMax() {
        Object max = this.getMax();
        int last = this.mNodes.size() - 1;
        this.mNodes.set(0, this.mNodes.get(last));
        this.mNodes.remove(last);
        int i = 0;
        while (true) {
            int l = 2 * i;
            int r = 2 * i + 1;
            int largest = l < this.mNodes.size() && this.compare(this.mNodes.get(l), this.mNodes.get(i)) > 0 ? l : i;
            if (r < this.mNodes.size() && this.compare(this.mNodes.get(r), this.mNodes.get(largest)) > 0) {
                largest = r;
            }
            if (largest == i) break;
            Object o = this.mNodes.get(i);
            this.mNodes.set(i, this.mNodes.get(largest));
            this.mNodes.set(largest, o);
            i = largest;
        }
        return max;
    }

    public int size() {
        return this.mNodes.size();
    }

    private static class Node {
        private Object mData;
        private Node mParent;

        Node(Object data, Node parent) {
            this.mData = data;
            this.mParent = parent;
        }

        Object getData() {
            return this.mData;
        }

        Node getParent() {
            return this.mParent;
        }
    }
}

