/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.OrderedListener;
import com.raplix.util.collections.UnorderedListener;
import java.util.Enumeration;

public final class Compare {
    private static final EqualityListener EQUALITY_LISTENER = new EqualityListener();
    private static final PermutationListener PERMUTATION_LISTENER = new PermutationListener();
    private static final PrefixListener PREFIX_LISTENER = new PrefixListener();
    private static final Object[] EMPTY = new Object[0];

    private Compare() {
    }

    private static boolean isElementEqual(Object e1, Object e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (e2 == null) {
            return false;
        }
        if (CollectionUtil.isEnumerable(e1) && CollectionUtil.isEnumerable(e2)) {
            return Compare.isEqual(e1, e2);
        }
        return e1.equals(e2);
    }

    public static void compareOrdered(Object c1, Object c2, OrderedListener l) {
        if (c1 == null) {
            c1 = EMPTY;
        }
        if (c2 == null) {
            c2 = EMPTY;
        }
        Enumeration e1 = CollectionUtil.getEnumeration(c1);
        Enumeration e2 = CollectionUtil.getEnumeration(c2);
        int i = 0;
        while (e1.hasMoreElements() && e2.hasMoreElements()) {
            Object el2;
            Object el1 = e1.nextElement();
            if (Compare.isElementEqual(el1, el2 = e2.nextElement())) {
                l.match(el1, el2, i);
            } else {
                l.mismatch(el1, el2, i);
            }
            ++i;
        }
        while (e1.hasMoreElements()) {
            l.missing2(e1.nextElement(), i++);
        }
        while (e2.hasMoreElements()) {
            l.missing1(e2.nextElement(), i++);
        }
    }

    public static void compareUnordered(Object c1, Object c2, UnorderedListener l) {
        if (c1 == null) {
            c1 = EMPTY;
        }
        if (c2 == null) {
            c2 = EMPTY;
        }
        int size2 = CollectionUtil.getSize(c2);
        boolean[] used = new boolean[size2];
        int i1 = 0;
        Enumeration e1 = CollectionUtil.getEnumeration(c1);
        while (e1.hasMoreElements()) {
            Object el1 = e1.nextElement();
            int i2 = 0;
            Enumeration e2 = CollectionUtil.getEnumeration(c2);
            while (e2.hasMoreElements()) {
                Object el2 = e2.nextElement();
                if (!used[i2] && Compare.isElementEqual(el1, el2)) {
                    used[i2] = true;
                    l.match(el1, i1, el2, i2);
                    break;
                }
                ++i2;
            }
            if (i2 == size2) {
                l.missing2(el1, i1);
            }
            ++i1;
        }
        int i2 = 0;
        Enumeration e2 = CollectionUtil.getEnumeration(c2);
        while (e2.hasMoreElements()) {
            Object el2 = e2.nextElement();
            if (!used[i2]) {
                l.missing1(el2, i2);
            }
            ++i2;
        }
    }

    public static boolean isEqual(Object c1, Object c2) {
        try {
            Compare.compareOrdered(c1, c2, EQUALITY_LISTENER);
            return true;
        }
        catch (MismatchException ex) {
            return false;
        }
    }

    public static boolean isPermutation(Object c1, Object c2) {
        try {
            Compare.compareUnordered(c1, c2, PERMUTATION_LISTENER);
            return true;
        }
        catch (MismatchException ex) {
            return false;
        }
    }

    public static boolean isPrefix(Object c1, Object c2) {
        try {
            Compare.compareOrdered(c1, c2, PREFIX_LISTENER);
            return true;
        }
        catch (MismatchException ex) {
            return false;
        }
    }

    public static int indexOf(Object c, Object e) {
        if (c == null) {
            return -1;
        }
        int i = 0;
        Enumeration ce = CollectionUtil.getEnumeration(c);
        while (ce.hasMoreElements()) {
            if (Compare.isElementEqual(e, ce.nextElement())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class PrefixListener
    implements OrderedListener {
        private PrefixListener() {
        }

        public void match(Object o1, Object o2, int i) {
        }

        public void mismatch(Object o1, Object o2, int i) {
            throw new MismatchException();
        }

        public void missing1(Object o2, int i2) {
        }

        public void missing2(Object o1, int i1) {
            throw new MismatchException();
        }
    }

    private static class PermutationListener
    implements UnorderedListener {
        private PermutationListener() {
        }

        public void match(Object o1, int i1, Object o2, int i2) {
        }

        public void missing1(Object o2, int i2) {
            throw new MismatchException();
        }

        public void missing2(Object o1, int i1) {
            throw new MismatchException();
        }
    }

    private static class EqualityListener
    implements OrderedListener {
        private EqualityListener() {
        }

        public void match(Object o1, Object o2, int i) {
        }

        public void mismatch(Object o1, Object o2, int i) {
            throw new MismatchException();
        }

        public void missing1(Object o2, int i2) {
            throw new MismatchException();
        }

        public void missing2(Object o1, int i1) {
            throw new MismatchException();
        }
    }

    private static class MismatchException
    extends RuntimeException {
        MismatchException() {
        }
    }
}

