/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.collections;

import com.raplix.util.collections.ArrayEnumeration;
import com.raplix.util.collections.ArrayStuffer;
import com.raplix.util.collections.CollectionStuffer;
import com.raplix.util.collections.IteratorEnumeration;
import com.raplix.util.collections.Mapper;
import com.raplix.util.collections.PackageInfo;
import com.raplix.util.collections.Stuffer;
import com.raplix.util.reflect.ClassUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public final class CollectionUtil {
    public static int FIRST_INDEX = 0;
    public static int LAST_INDEX = -1;

    private CollectionUtil() {
    }

    private static boolean isEnumerationClass(Class cls) {
        return Enumeration.class.isAssignableFrom(cls);
    }

    private static boolean isEnumeration(Object c) {
        return c instanceof Enumeration;
    }

    private static boolean isCollectionClass(Class cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    private static boolean isCollection(Object c) {
        return c instanceof Collection;
    }

    private static boolean isArrayClass(Class cls) {
        return cls.isArray();
    }

    private static boolean isArray(Object c) {
        return CollectionUtil.isArrayClass(c.getClass());
    }

    private static Object getCollection(Class cls, int size) {
        if (CollectionUtil.isCollectionClass(cls)) {
            return ClassUtil.createObject(cls);
        }
        if (CollectionUtil.isArrayClass(cls)) {
            return Array.newInstance(cls.getComponentType(), size);
        }
        return Array.newInstance(cls, size);
    }

    private static Vector cacheEnumeration(Enumeration e) {
        Vector cache = new Vector();
        while (e.hasMoreElements()) {
            cache.addElement(e.nextElement());
        }
        return cache;
    }

    public static boolean isEnumerableClass(Class cls) {
        return CollectionUtil.isCollectionClass(cls) || CollectionUtil.isArrayClass(cls) || CollectionUtil.isEnumerationClass(cls);
    }

    public static boolean isEnumerable(Object c) {
        return CollectionUtil.isEnumerableClass(c.getClass());
    }

    public static Enumeration getEnumeration(Object c) {
        if (CollectionUtil.isEnumeration(c)) {
            return (Enumeration)c;
        }
        if (CollectionUtil.isCollection(c)) {
            return new IteratorEnumeration(((Collection)c).iterator());
        }
        if (CollectionUtil.isArray(c)) {
            return new ArrayEnumeration(c);
        }
        PackageInfo.throwNotEnumerable(c);
        return null;
    }

    public static Stuffer getStuffer(Object c) {
        if (CollectionUtil.isCollection(c)) {
            return new CollectionStuffer((Collection)c);
        }
        if (CollectionUtil.isArray(c)) {
            return new ArrayStuffer(c);
        }
        PackageInfo.throwNotEnumerable(c);
        return null;
    }

    public static int getSize(Object c) {
        if (CollectionUtil.isEnumeration(c)) {
            Enumeration e = (Enumeration)c;
            int size = 0;
            while (e.hasMoreElements()) {
                e.nextElement();
                ++size;
            }
            return size;
        }
        if (CollectionUtil.isCollection(c)) {
            return ((Collection)c).size();
        }
        if (CollectionUtil.isArray(c)) {
            return Array.getLength(c);
        }
        PackageInfo.throwNotEnumerable(c);
        return 0;
    }

    public static Class getElementType(Object c) {
        if (CollectionUtil.isArray(c)) {
            return c.getClass().getComponentType();
        }
        if (CollectionUtil.isCollection(c)) {
            return null;
        }
        PackageInfo.throwNotEnumerable(c);
        return null;
    }

    public static void map(Object cIn, Object cOut, Mapper mapper) throws Exception {
        mapper.setMappedClass(CollectionUtil.getElementType(cOut));
        Stuffer s = CollectionUtil.getStuffer(cOut);
        Enumeration e = CollectionUtil.getEnumeration(cIn);
        while (e.hasMoreElements()) {
            s.append(mapper.map(e.nextElement()));
        }
    }

    public static void map(Object cIn, Object cOut) {
        Stuffer s = CollectionUtil.getStuffer(cOut);
        Enumeration e = CollectionUtil.getEnumeration(cIn);
        while (e.hasMoreElements()) {
            s.append(e.nextElement());
        }
    }

    public static Object mapClass(Object cIn, Class cOutClass, Mapper mapper) throws Exception {
        if (CollectionUtil.isEnumeration(cIn)) {
            cIn = CollectionUtil.cacheEnumeration((Enumeration)cIn);
        }
        Object cOut = CollectionUtil.getCollection(cOutClass, CollectionUtil.getSize(cIn));
        CollectionUtil.map(cIn, cOut, mapper);
        return cOut;
    }

    public static Object mapClass(Object cIn, Class cOutClass) {
        if (CollectionUtil.isEnumeration(cIn)) {
            cIn = CollectionUtil.cacheEnumeration((Enumeration)cIn);
        }
        Object cOut = CollectionUtil.getCollection(cOutClass, CollectionUtil.getSize(cIn));
        CollectionUtil.map(cIn, cOut);
        return cOut;
    }

    public static Object sliceClass(Object cIn, Class cOutClass, int beginIndex, int endIndex) {
        int i;
        int inSize;
        if (CollectionUtil.isEnumeration(cIn)) {
            cIn = CollectionUtil.cacheEnumeration((Enumeration)cIn);
        }
        if (beginIndex > (inSize = CollectionUtil.getSize(cIn)) || beginIndex < 0) {
            PackageInfo.throwOutOfBounds(beginIndex, inSize);
        }
        if (endIndex == LAST_INDEX) {
            endIndex = inSize;
        } else if (endIndex > inSize || endIndex < 0) {
            PackageInfo.throwOutOfBounds(endIndex, inSize);
        }
        int outSize = Math.max(endIndex - beginIndex, 0);
        Object cOut = CollectionUtil.getCollection(cOutClass, outSize);
        Stuffer s = CollectionUtil.getStuffer(cOut);
        Enumeration e = CollectionUtil.getEnumeration(cIn);
        for (i = 0; i < beginIndex; ++i) {
            e.nextElement();
        }
        while (i < endIndex) {
            s.append(e.nextElement());
            ++i;
        }
        return cOut;
    }

    public static Object toPrimitiveArray(Object src) {
        return CollectionUtil.mapClass(src, ClassUtil.getPrimitiveClass(CollectionUtil.getElementType(src)));
    }

    public static Object toObjectArray(Object src) {
        return CollectionUtil.mapClass(src, ClassUtil.getObjectClass(CollectionUtil.getElementType(src)));
    }

    public static String toString(Object c, String qualifier, String separator) {
        if (c == null) {
            return "[null]";
        }
        StringBuffer buffer = new StringBuffer();
        Enumeration e = CollectionUtil.getEnumeration(c);
        while (e.hasMoreElements()) {
            Object el = e.nextElement();
            if (el == null) {
                buffer.append("<null>");
            } else {
                buffer.append(qualifier);
                if (CollectionUtil.isEnumerable(el)) {
                    buffer.append(CollectionUtil.toString(el));
                } else {
                    buffer.append(el);
                }
                buffer.append(qualifier);
            }
            if (!e.hasMoreElements()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String toString(Object c) {
        return CollectionUtil.toString(c, "'", ",");
    }

    public static int hashCode(Object c, boolean ordered) {
        if (c == null) {
            return 0;
        }
        int code = 0;
        int i = 0;
        Enumeration e = CollectionUtil.getEnumeration(c);
        while (e.hasMoreElements()) {
            Object el = e.nextElement();
            int elcode = 1;
            if (el != null) {
                elcode = CollectionUtil.isEnumerable(el) ? CollectionUtil.hashCode(el, false) : el.hashCode();
            }
            if (ordered) {
                code += ++i * elcode;
                continue;
            }
            code += elcode;
        }
        return code;
    }

    public static int hashCode(Object c) {
        return CollectionUtil.hashCode(c, true);
    }
}

