/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.cache;

import com.raplix.util.cache.CacheBase;
import com.raplix.util.cache.RefWrapper;
import com.raplix.util.cache.RefWrapperFactory;
import com.raplix.util.cache.ValueFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;

public class WrappedValueCache
extends CacheBase {
    private HashMap mRMap = new HashMap();
    private ReferenceQueue mRQueue = new ReferenceQueue();
    private RefWrapperFactory mFactory;

    public WrappedValueCache(ValueFactory vFactory, RefWrapperFactory wFactory) {
        super(new HashMap(), vFactory);
        this.mFactory = wFactory;
    }

    public WrappedValueCache() {
        this((ValueFactory)null, (RefWrapperFactory)null);
    }

    public synchronized Object get(Object key, ValueFactory factory) {
        Object value;
        RefWrapper rw = (RefWrapper)this.getMap().get(key);
        if (rw != null) {
            value = rw.getReferent();
            if (value != null) {
                this.returning(key, value);
                return value;
            }
            this.getMap().remove(key);
            this.mRMap.remove(rw.getReference());
            this.reclaimed(key);
        }
        if (factory == null) {
            factory = this.getDefaultFactory();
        }
        if ((value = factory.createValue(key)) == null) {
            return null;
        }
        rw = factory instanceof RefWrapperFactory ? ((RefWrapperFactory)((Object)factory)).createWrapper(this.mFactory, key, value, this.mRQueue) : this.mFactory.createWrapper(null, key, value, this.mRQueue);
        this.getMap().put(key, rw);
        this.mRMap.put(rw.getReference(), key);
        this.added(key, value);
        this.returning(key, value);
        return value;
    }

    public synchronized void remove(Object key) {
        RefWrapper rw = (RefWrapper)this.getMap().remove(key);
        if (rw != null) {
            this.mRMap.remove(rw.getReference());
            this.removed(key);
        }
    }

    public synchronized void reclaim() {
        Reference r;
        while ((r = this.mRQueue.poll()) != null) {
            Object key = this.mRMap.remove(r);
            if (key == null) continue;
            this.getMap().remove(key);
            this.reclaimed(key);
        }
        return;
    }

    public synchronized void clear() {
        super.clear();
        this.mRMap.clear();
    }
}

