/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.cache;

import com.raplix.util.cache.Cache;
import com.raplix.util.cache.IdleValueFactory;
import com.raplix.util.cache.ValueFactory;
import com.raplix.util.logger.Logger;
import java.util.WeakHashMap;

public class LRUCache
implements Cache {
    private Cache mBaseCache;
    private WeakHashMap mTimeStamps = new WeakHashMap();
    private int mMaxSize;
    private long mTime = 0L;

    public LRUCache(Cache baseCache, int maxSize) {
        this.mBaseCache = baseCache;
        this.mMaxSize = maxSize;
    }

    public Cache getBaseCache() {
        return this.mBaseCache;
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public ValueFactory getDefaultFactory() {
        return this.getBaseCache().getDefaultFactory();
    }

    public synchronized Object get(Object key, ValueFactory factory) {
        Object value = this.getBaseCache().get(key, factory);
        if (value == null) {
            return null;
        }
        this.mTimeStamps.remove(key);
        this.mTimeStamps.put(key, new Long(this.mTime++));
        if (this.getSize() > this.getMaxSize()) {
            while (true) {
                this.reclaim();
                if (this.getSize() <= this.getMaxSize()) break;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Cache size too big: " + this.getSize() + " with maximum: " + this.getMaxSize(), this);
                }
                Object[] keys = this.mTimeStamps.keySet().toArray();
                Object minKey = null;
                long minTime = 0L;
                for (int i = 0; i < keys.length; ++i) {
                    Long time = (Long)this.mTimeStamps.get(keys[i]);
                    if (time == null) continue;
                    if (this.getBaseCache().get(keys[i], IdleValueFactory.GLOBAL) == null) {
                        this.mTimeStamps.remove(keys[i]);
                        continue;
                    }
                    if (minKey != null && time >= minTime) continue;
                    minKey = keys[i];
                    minTime = time;
                }
                if (minKey == null) continue;
                this.remove(minKey);
            }
        }
        return value;
    }

    public synchronized void remove(Object key) {
        this.getBaseCache().remove(key);
        this.mTimeStamps.remove(key);
    }

    public synchronized void clear() {
        this.getBaseCache().clear();
        this.mTimeStamps.clear();
    }

    public synchronized int getSize() {
        return this.getBaseCache().getSize();
    }

    public synchronized Object[] getKeys() {
        return this.getBaseCache().getKeys();
    }

    public synchronized void reclaim() {
        this.getBaseCache().reclaim();
    }
}

