/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.cache;

import com.raplix.util.cache.Cache;
import com.raplix.util.cache.ValueFactory;
import com.raplix.util.logger.Logger;
import java.util.Map;

abstract class CacheBase
implements Cache {
    private Map mMap;
    private ValueFactory mFactory;

    protected CacheBase(Map map, ValueFactory factory) {
        this.mMap = map;
        this.mFactory = factory;
    }

    protected void returning(Object key, Object value) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Returning cached entry: (" + key + "," + value + ")", this);
        }
    }

    protected void added(Object key, Object value) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Added new cache entry: (" + key + "," + value + ")", this);
        }
    }

    protected void removed(Object key) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Removed cache entry for key: " + key, this);
        }
    }

    protected void reclaimed(Object key) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Reclaimed cache entry for key: " + key, this);
        }
    }

    protected Map getMap() {
        return this.mMap;
    }

    public ValueFactory getDefaultFactory() {
        return this.mFactory;
    }

    public synchronized int getSize() {
        return this.getMap().size();
    }

    public synchronized Object[] getKeys() {
        return this.getMap().keySet().toArray();
    }

    public synchronized void clear() {
        this.getMap().clear();
    }
}

