/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import com.raplix.util.PackageInfo;
import com.raplix.util.TimeUtil;
import com.raplix.util.Util;

public class Validate {
    public static final int MAX_SHORT_NAME_LENGTH = 32;
    public static final int MAX_LONG_NAME_LENGTH = 512;
    public static final int MAX_DESCRIPTION_LENGTH = 1024;

    public static boolean isValidIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        String[] pieces = Util.splitStringNeighboringDelimitors(ipAddress, ".");
        if (pieces.length != 4) {
            return false;
        }
        try {
            int x = Integer.parseInt(pieces[0]);
            if (x < 1 || x >= 256) {
                return false;
            }
            for (int i = 1; i < pieces.length; ++i) {
                int y = Integer.parseInt(pieces[i]);
                if (y >= 0 && y < 256) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean isValidSSHPort(int port) {
        return port > 65535 && port <= 131071;
    }

    public static boolean isValidObjectName(String name, int maxLength) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0 || name.length() > maxLength) {
            return false;
        }
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            return false;
        }
        return Validate.hasValidNameChars(name);
    }

    public static boolean isValidObjectDescription(String description) {
        if (description == null) {
            return false;
        }
        if (description.length() > 1024) {
            return false;
        }
        return Validate.hasValidDescriptionChars(description);
    }

    public static boolean isValidFirstCharForName(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    private static boolean hasValidNameChars(String inString) {
        if (inString == null) {
            return false;
        }
        for (int i = 0; i < inString.length(); ++i) {
            if (Validate.isValidNameChar(inString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasValidDescriptionChars(String inString) {
        if (inString == null) {
            return false;
        }
        for (int i = 0; i < inString.length(); ++i) {
            if (Validate.isValidDescriptionChar(inString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNameChar(char ch) {
        String validchars = "-_. ";
        return Character.isDigit(ch) || Character.isLetter(ch) || validchars.indexOf(ch) != -1;
    }

    public static void assertValidTimeout(double value, int type) {
        if (TimeUtil.convert(value, type, 2) < 1.0 || TimeUtil.convert(value, type, 4) > 7.0) {
            throw PackageInfo.createBadTimeout();
        }
    }

    private static boolean isValidDescriptionChar(char ch) {
        String validchars = "!@#$%^&*()_+-={}[]\\|:;\"`'<>,.?/~ ";
        return Character.isDigit(ch) || Character.isLetter(ch) || validchars.indexOf(ch) != -1;
    }
}

