/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final String LOGGER_CATEGORY = Util.class.getName();
    private static final boolean sIsJDK14 = System.getProperty("java.version").startsWith("1.4");
    private static final boolean sIsJDK15 = System.getProperty("java.version").startsWith("1.5");
    private static final int BUFFER_SIZE = 65536;
    private static final String EMPTY_ARR_STRING = "[empty]";

    public static String[] splitString(String theString, String theDelimiters) {
        if (theString == null) {
            throw new IllegalArgumentException("incoming string is null");
        }
        Vector<String> resultVec = new Vector<String>();
        StringTokenizer st = new StringTokenizer(theString, theDelimiters, false);
        while (st.hasMoreTokens()) {
            resultVec.addElement(st.nextToken());
        }
        Object[] results = new String[resultVec.size()];
        resultVec.copyInto(results);
        return results;
    }

    public static String[] splitStringNeighboringDelimitors(String theString, String theDelimiters) {
        if (theString == null) {
            throw new IllegalArgumentException("incoming string is null");
        }
        Vector<String> resultVec = new Vector<String>();
        StringTokenizer st = new StringTokenizer(theString, theDelimiters, true);
        boolean prevWasDelimiter = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1 && theDelimiters.indexOf(token) >= 0) {
                if (prevWasDelimiter) {
                    resultVec.addElement("");
                    continue;
                }
                prevWasDelimiter = true;
                continue;
            }
            resultVec.addElement(token);
            prevWasDelimiter = false;
        }
        Object[] results = new String[resultVec.size()];
        resultVec.copyInto(results);
        return results;
    }

    public static ArrayList createArrayListFromArray(Object[] arr, boolean fSort) {
        if (arr == null) {
            return new ArrayList();
        }
        int nItems = arr.length;
        ArrayList<Object> list = new ArrayList<Object>(nItems);
        for (int i = 0; i < nItems; ++i) {
            list.add(arr[i]);
        }
        if (fSort) {
            Collections.sort(list);
        }
        return list;
    }

    public static StringBuffer getOutputFromProcess(InputStream istream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
        StringBuffer result = new StringBuffer(1024);
        while ((line = reader.readLine()) != null) {
            result.append(line);
            result.append("\n");
        }
        return result;
    }

    public static final void copyStream(InputStream input, OutputStream output) throws IOException {
        int nBytesRead;
        byte[] buffer = new byte[65536];
        while ((nBytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, nBytesRead);
        }
        output.flush();
    }

    public static final StringBuffer prettyPrintDirectory(Object[] names, Object[] isDir, Object[] size) {
        StringBuffer buf = new StringBuffer(1024);
        for (int i = 0; i < names.length; ++i) {
            if (((Boolean)isDir[i]).booleanValue()) {
                buf.append("d ");
            } else {
                buf.append("  ");
            }
            String sizeStr = size[i].toString();
            for (int j = sizeStr.length(); j < 10; ++j) {
                buf.append(' ');
            }
            buf.append(sizeStr);
            buf.append(' ');
            buf.append(names[i].toString());
            buf.append("\n");
        }
        return buf;
    }

    public static String getStringFromArray(Object[] arr, String delim) {
        if (arr == null) {
            return EMPTY_ARR_STRING;
        }
        int size = arr.length;
        StringBuffer buf = new StringBuffer(512);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String getStringFromArray(int[] arr, String delim) {
        if (arr == null) {
            return EMPTY_ARR_STRING;
        }
        int size = arr.length;
        StringBuffer buf = new StringBuffer(512);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String getStringFromArray(boolean[] arr, String delim) {
        if (arr == null) {
            return EMPTY_ARR_STRING;
        }
        int size = arr.length;
        StringBuffer buf = new StringBuffer(512);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String grabRestOfLine(StringTokenizer st) {
        StringBuffer buf = new StringBuffer(64);
        while (st.hasMoreTokens()) {
            buf.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String replaceCharWithStr(String s, char cToReplace, String replacer) {
        if (s == null) {
            return "";
        }
        if (s.indexOf(cToReplace) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        char[] buf = s.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            char ch = buf[i];
            if (ch == cToReplace) {
                sb.append(replacer);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escapePathname(String path) {
        StringBuffer result = new StringBuffer(32);
        if (path.indexOf(32) != -1) {
            result.append('\"');
            result.append(path);
            result.append('\"');
            return result.toString();
        }
        return path;
    }

    public static String escapeHTMLTags(String inHTML) {
        if (inHTML == null) {
            return null;
        }
        if (inHTML.indexOf(60) < 0 && inHTML.indexOf(62) < 0) {
            return inHTML;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < inHTML.length(); ++i) {
            char ch = inHTML.charAt(i);
            if (ch == '<') {
                result.append("&lt;");
                continue;
            }
            if (ch == '>') {
                result.append("&gt;");
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String getStackTrace(Exception ex) {
        StringWriter strWriter = new StringWriter(512);
        PrintWriter writer = new PrintWriter(strWriter);
        ex.printStackTrace(writer);
        writer.flush();
        strWriter.flush();
        return strWriter.toString();
    }

    public static boolean isJDK14() {
        return sIsJDK14;
    }

    public static boolean isJDK15() {
        return sIsJDK15;
    }

    public static String trimTrailingSlash(String input) {
        if (input.equals("")) {
            return "";
        }
        if (input.length() == 1) {
            return input;
        }
        String result = input;
        if (input != null && (input.charAt(input.length() - 1) == '/' || input.charAt(input.length() - 1) == '\\')) {
            result = input.substring(0, input.length() - 1);
        }
        return result;
    }

    public static String[] parseCommandLine(String inCmdLine) {
        int i;
        Vector<String> resultVec = new Vector<String>(4);
        StringBuffer curToken = new StringBuffer(16);
        boolean fQuoting = false;
        boolean fSawBackslash = false;
        inCmdLine = inCmdLine.trim();
        int lineLen = inCmdLine.length();
        if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
            Logger.debug("inCmdLine: (" + inCmdLine.length() + ") " + inCmdLine, LOGGER_CATEGORY);
        }
        for (i = 0; i < lineLen; ++i) {
            char curChar = inCmdLine.charAt(i);
            if (curChar != ' ') {
                if (curChar != '\"') {
                    curToken.append(curChar);
                } else if (!fSawBackslash) {
                    fQuoting = !fQuoting;
                } else {
                    curToken.append(curChar);
                }
            } else if (fQuoting) {
                curToken.append(curChar);
            } else {
                if (Util.shouldAddToken(curToken)) {
                    resultVec.add(curToken.toString());
                }
                curToken.delete(0, curToken.length());
            }
            fSawBackslash = curChar == '\\';
        }
        if (Util.shouldAddToken(curToken)) {
            resultVec.addElement(curToken.toString());
        }
        int nTokens = resultVec.size();
        Object[] resultArr = new String[nTokens];
        for (i = 0; i < nTokens; ++i) {
            resultArr[i] = (String)resultVec.elementAt(i);
        }
        if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
            Logger.debug("Tokinezed cmdLine: " + Util.getStringFromArray(resultArr, ", "), LOGGER_CATEGORY);
        }
        return resultArr;
    }

    private static boolean shouldAddToken(StringBuffer token) {
        int tokenLen = token.length();
        return token != null && tokenLen > 0 && (tokenLen != 1 || token.charAt(0) != ' ');
    }

    public static Vector soapVectorToVector(Object soapVector) {
        if (soapVector instanceof Vector) {
            return (Vector)soapVector;
        }
        if (soapVector instanceof Object[]) {
            Object[] elements = (Object[])soapVector;
            Vector<Object> result = new Vector<Object>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                result.addElement(elements[i]);
            }
            return result;
        }
        return null;
    }

    public static String convertToLocalFileSeparators(String inPath) {
        if (File.separatorChar == '/') {
            return inPath.replace('\\', '/');
        }
        return inPath.replace('/', '\\');
    }

    public static String convertToNetworkFileSeparators(String inPath) {
        return inPath.replace('\\', '/');
    }

    public static boolean isEqual(Object inA, Object inB) {
        return ObjectUtil.equals(inA, inB);
    }
}

