/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

public final class TimeUtil {
    private static final long SCALE_MSEC = 1L;
    private static final long SCALE_SEC = 1000L;
    private static final long SCALE_MIN = 60000L;
    private static final long SCALE_HOUR = 3600000L;
    private static final long SCALE_DAY = 86400000L;
    private static final long SCALE_WEEK = 604800000L;
    private static final long[] SCALES = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L};
    public static final int MSEC = 0;
    public static final int SEC = 1;
    public static final int MIN = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final int WEEK = 5;

    private TimeUtil() {
    }

    public static double getScale(int fromType, int toType) {
        return (double)SCALES[fromType] / (double)SCALES[toType];
    }

    public static double convert(double value, int fromType, int toType) {
        return value * TimeUtil.getScale(fromType, toType);
    }

    public static long convertRound(double value, int fromType, int toType) {
        return Math.round(TimeUtil.convert(value, fromType, toType));
    }
}

