/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

public class Semaphore {
    private int mValue = 0;
    private int mWaitCount = 0;
    private int mNotifyCount = 0;

    public Semaphore() {
    }

    public Semaphore(int initial) {
        this.mValue = initial;
    }

    public synchronized void P() throws InterruptedException {
        if (this.mValue <= this.mWaitCount) {
            ++this.mWaitCount;
            try {
                do {
                    this.wait();
                } while (this.mNotifyCount == 0);
            }
            catch (InterruptedException e) {
                this.notify();
                throw e;
            }
            finally {
                --this.mWaitCount;
            }
            --this.mNotifyCount;
        } else if (this.mNotifyCount > this.mWaitCount) {
            --this.mNotifyCount;
        }
        --this.mValue;
    }

    public synchronized void V() {
        ++this.mValue;
        if (this.mValue > 0 && this.mWaitCount > this.mNotifyCount) {
            ++this.mNotifyCount;
            this.notify();
        }
    }

    public synchronized int getValue() {
        return this.mValue;
    }

    public synchronized String toString() {
        return "Semaphore(" + this.mValue + ", wc: " + this.mWaitCount + ", nc: " + this.mNotifyCount + ")";
    }
}

