/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.Group;
import com.raplix.util.platform.posix.Passwd;
import com.raplix.util.platform.posix.Process;

public class Security {
    public static final String ROOT_USER = "root";

    public static boolean isUserValid(String inUser) {
        return Security.createPasswd(inUser) != null;
    }

    public static boolean isGroupValid(String inGroup) {
        return Security.createGroup(inGroup) != null;
    }

    public static boolean isRootOrHasSetuidPrivileges() {
        try {
            return Process.getEffectiveUID() == new Passwd(ROOT_USER).getUID();
        }
        catch (IllegalArgumentException ex) {
            if (Logger.isDebugEnabled(Security.class)) {
                Logger.debug("error finding whether or not we are runnig as root/have setuid", ex, Security.class);
            }
            return false;
        }
    }

    public static Passwd createPasswd(String inUser) {
        block10: {
            if (inUser == null) {
                return null;
            }
            try {
                Passwd tester = new Passwd(Long.valueOf(inUser));
                if (Logger.isDebugEnabled(Security.class)) {
                    Logger.debug(inUser + " is a valid userid", Security.class);
                }
                return tester;
            }
            catch (NumberFormatException nfe) {
                if (Logger.isDebugEnabled(Security.class)) {
                    Logger.debug(inUser + " is not a valid number - continuing", Security.class);
                }
            }
            catch (IllegalArgumentException iae) {
                if (!Logger.isDebugEnabled(Security.class)) break block10;
                Logger.debug(inUser + " is a valid number, but is not a valid userid - continuing", Security.class);
            }
        }
        try {
            Passwd tester = new Passwd(inUser);
            if (Logger.isDebugEnabled(Security.class)) {
                Logger.debug(inUser + " is a valid username", Security.class);
            }
            return tester;
        }
        catch (IllegalArgumentException iae) {
            if (Logger.isDebugEnabled(Security.class)) {
                Logger.debug(inUser + " is not a valid username", Security.class);
            }
            return null;
        }
    }

    public static Group createGroup(String inGroup) {
        block10: {
            if (inGroup == null) {
                return null;
            }
            try {
                Group tester = new Group(Long.valueOf(inGroup));
                if (Logger.isDebugEnabled(Security.class)) {
                    Logger.debug(inGroup + " is a valid groupid", Security.class);
                }
                return tester;
            }
            catch (NumberFormatException nfe) {
                if (Logger.isDebugEnabled(Security.class)) {
                    Logger.debug(inGroup + " is not a valid number - continuing", Security.class);
                }
            }
            catch (IllegalArgumentException iae) {
                if (!Logger.isDebugEnabled(Security.class)) break block10;
                Logger.debug(inGroup + " is a valid number, but is not a valid groupid - continuing", Security.class);
            }
        }
        try {
            Group tester = new Group(inGroup);
            if (Logger.isDebugEnabled(Security.class)) {
                Logger.debug(inGroup + " is a valid groupname", Security.class);
            }
            return tester;
        }
        catch (IllegalArgumentException iae) {
            if (Logger.isDebugEnabled(Security.class)) {
                Logger.debug(inGroup + " is not a valid groupname", Security.class);
            }
            return null;
        }
    }

    public static boolean isProcessOwnerSameAsUser(String inUser) {
        Passwd inUserPwd = Security.createPasswd(inUser);
        if (inUserPwd == null) {
            return false;
        }
        return Process.getEffectiveUID() == inUserPwd.getUID();
    }

    public static boolean isProcessGroupSameAsGroup(String inGroup) {
        Group inUserGrp = Security.createGroup(inGroup);
        if (inUserGrp == null) {
            return false;
        }
        return Process.getEffectiveGID() == inUserGrp.getGID();
    }
}

