/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import java.io.PrintWriter;

public final class PrintUtil {
    private static final char ASTERISK = '*';
    private static final char SPACE = ' ';
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;

    private PrintUtil() {
    }

    public static void fill(PrintWriter writer, int count, char c) {
        for (int i = 0; i < count; ++i) {
            writer.print(c);
        }
    }

    public static void print(PrintWriter writer, String value, int align, int width, boolean crop) {
        if (value == null) {
            PrintUtil.fill(writer, width, '*');
            return;
        }
        int len = value.length();
        if (len >= width) {
            if (crop) {
                writer.print(value.substring(0, width));
                return;
            }
            writer.print(value);
            return;
        }
        len = width - len;
        if (align == 1) {
            int halfLen = len / 2;
            PrintUtil.fill(writer, halfLen, ' ');
            writer.print(value);
            PrintUtil.fill(writer, len - halfLen, ' ');
            return;
        }
        if (align == 0) {
            writer.print(value);
            PrintUtil.fill(writer, len, ' ');
            return;
        }
        PrintUtil.fill(writer, len, ' ');
        writer.print(value);
    }
}

