/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import com.raplix.rolloutexpress.node.bootstrap.BootStrap;
import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Hashtable;

public class ClassLoaderFactory {
    private static final String JAR_SUFFIX = ".jar";
    public static final String UPGRADE_DIR_NAME = "upgrade";

    public static ClassLoader createLoader(File rootDir, ClassLoader parent) throws MalformedURLException {
        File[] jarPaths = ClassLoaderFactory.getJarPaths(rootDir);
        Arrays.sort(jarPaths, BootStrap.NameComparator.INSTANCE);
        URL[] urls = new URL[jarPaths.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = jarPaths[i].toURL();
            if (i != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(jarPaths[i].getAbsolutePath());
        }
        if (Logger.isDebugEnabled(ClassLoaderFactory.class)) {
            Logger.debug("Jars loaded from " + rootDir.getName() + " : " + sb.toString(), ClassLoaderFactory.class);
        }
        return new URLClassLoader(urls, parent);
    }

    private static File[] getJarPaths(File rootDir) {
        Hashtable jarTable = new Hashtable();
        ClassLoaderFactory.putJarsInHash(rootDir, jarTable);
        File upgradeDir = new File(rootDir, UPGRADE_DIR_NAME);
        if (upgradeDir.exists()) {
            ClassLoaderFactory.findUpgradeJars(upgradeDir, jarTable);
        } else if (Logger.isDebugEnabled(ClassLoaderFactory.class)) {
            Logger.debug("Common upgrade dir does not exist:" + upgradeDir.getAbsolutePath(), ClassLoaderFactory.class);
        }
        return jarTable.values().toArray(new File[jarTable.size()]);
    }

    private static void findUpgradeJars(File upgradeDir, Hashtable jarTable) {
        File[] upgrades = upgradeDir.listFiles(UpgradeDirFilter.INSTANCE);
        if (upgrades == null && Logger.isErrorEnabled(ClassLoaderFactory.class)) {
            Logger.error("Error listing files in the upgrade dir:" + upgradeDir.getAbsolutePath(), ClassLoaderFactory.class);
        }
        Arrays.sort(upgrades, VersionComparator.INSTANCE);
        for (int i = 0; i < upgrades.length; ++i) {
            ClassLoaderFactory.putJarsInHash(upgrades[i], jarTable);
        }
    }

    private static void putJarsInHash(File libDir, Hashtable jarTable) {
        File[] jars = libDir.listFiles(JarFilter.INSTANCE);
        if (jars != null) {
            for (int i = 0; i < jars.length; ++i) {
                jarTable.put(jars[i].getName(), jars[i].getAbsoluteFile());
            }
        }
    }

    private static class JarFilter
    implements FileFilter {
        public static final JarFilter INSTANCE = new JarFilter();

        private JarFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(ClassLoaderFactory.JAR_SUFFIX);
        }
    }

    public static class UpgradeDirFilter
    implements FileFilter {
        public static final UpgradeDirFilter INSTANCE = new UpgradeDirFilter();

        private UpgradeDirFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() && this.isVersion(pathname.getName());
        }

        private boolean isVersion(String name) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return false;
            }
            return true;
        }
    }
}

