/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;

public class Checksum {
    public static final int BLOCK_READ_SIZE = 65536;
    public static final long WARN_FILE_SIZE = 1000000L;

    public static long calculateChecksum(byte[] inByteArray) {
        Adler32 sum = new Adler32();
        sum.update(inByteArray);
        return sum.getValue();
    }

    public static long calculateChecksum(InputStream inStream) throws IOException {
        int len;
        Adler32 sum = new Adler32();
        byte[] block = new byte[65536];
        while ((len = inStream.read(block)) != -1) {
            sum.update(block, 0, len);
        }
        return sum.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateChecksum(File inFile) throws IOException {
        if (inFile.length() > 1000000L && Logger.isWarnEnabled(Checksum.class.getName())) {
            Logger.warn("Calculating checksum of large file " + inFile.getAbsolutePath() + " (" + inFile.length() + " bytes)", Checksum.class.getName());
        }
        FileInputStream in = new FileInputStream(inFile);
        try {
            long l = Checksum.calculateChecksum(in);
            return l;
        }
        finally {
            in.close();
        }
    }
}

