/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util;

import java.lang.reflect.Array;

public class ArrayEdit {
    public static Object[] add(Object[] arr, Object elem) {
        if (arr == null) {
            return null;
        }
        if (ArrayEdit.contains(arr, elem)) {
            return arr;
        }
        Object[] newArr = ArrayEdit.newTypedArray(arr, arr.length + 1);
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        newArr[arr.length] = elem;
        arr = newArr;
        return arr;
    }

    public static Object[] prepend(Object[] arr, Object elem, boolean allowDupicate) {
        if (arr == null) {
            return new Object[]{elem};
        }
        if (!allowDupicate && ArrayEdit.contains(arr, elem)) {
            return arr;
        }
        Object[] newArr = ArrayEdit.newTypedArray(arr, arr.length + 1);
        System.arraycopy(arr, 0, newArr, 1, arr.length);
        newArr[0] = elem;
        arr = newArr;
        return arr;
    }

    public static Object[] addMultiple(Object[] arr, Object[] elems) {
        if (elems == null) {
            return arr;
        }
        if (arr == null) {
            return null;
        }
        boolean[] useElem = new boolean[elems.length];
        int count = 0;
        for (int i = 0; i < elems.length; ++i) {
            if (ArrayEdit.contains(arr, elems[i])) {
                useElem[i] = false;
                continue;
            }
            useElem[i] = true;
            ++count;
        }
        Object[] newArr = ArrayEdit.newTypedArray(arr, arr.length + count);
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        int k = arr.length;
        for (int j = 0; j < elems.length; ++j) {
            if (!useElem[j]) continue;
            newArr[k] = elems[j];
            ++k;
        }
        arr = newArr;
        return arr;
    }

    public static Object[] remove(Object[] arr, Object elem) {
        if (arr == null) {
            return null;
        }
        int remIndex = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(elem)) continue;
            arr = ArrayEdit.removeElementAt(arr, i);
            break;
        }
        return arr;
    }

    public static Object[] removeElementAt(Object[] arr, int index) {
        Object[] newArr = ArrayEdit.newTypedArray(arr, arr.length - 1);
        System.arraycopy(arr, 0, newArr, 0, index);
        System.arraycopy(arr, index + 1, newArr, index, newArr.length - index);
        return newArr;
    }

    public static Object[] removeMultiple(Object[] arr, Object[] elems) {
        if (elems == null) {
            return arr;
        }
        for (int i = 0; i < elems.length; ++i) {
            arr = ArrayEdit.remove(arr, elems[i]);
        }
        return arr;
    }

    public static boolean contains(Object[] arr, Object elem) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(elem)) continue;
            return true;
        }
        return false;
    }

    public static Object[] newTypedArray(Object[] arr, int size) {
        arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        return arr;
    }
}

