/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.util;

import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.util.LinkAction;
import com.raplix.rolloutexpress.ui.web.util.LinkContext;
import com.raplix.rolloutexpress.ui.web.util.LinkObject;

public class Link {
    public static final String MSG_PERMISSION_HEADER = "permission.header";
    public static final String MSG_PERMISSION_PLUGIN_SINGULAR = "permission.msg.pluginsingular";
    public static final String MSG_PERMISSION_PLUGIN_PLURAL = "permission.msg.pluginplural";
    public static final String MSG_PERMISSION_PLUGIN_SHORT = "permission.msg.plugin.short";
    public static final String MSG_PERMISSION_SYSTEM = "permission.system";
    public static final String MSG_PERMISSION_ADMIN = "permission.admin";
    public static final String MSG_PERMISSION_WRITE = "permission.write";
    public static final String MSG_PERMISSION_CHECKIN_CURRENT = "permission.checkincurrent";
    public static final String MSG_PERMISSION_AUTORUN = "permission.autorun";
    public static final String MSG_PERMISSION_EXECUTE = "permission.execute";
    public static final String MSG_PERMISSION_EXECUTE_SYSTEM_FOLDER = "permission.execute.system.folder";
    public static final String MSG_PERMISSION_WRITE_ON_FOLDER = "permission.write.folder";
    public static final String MSG_PERMISSION_WRITE_ON_PARENT_FOLDER = "permission.write.parent.folder";
    public static final String MSG_PERMISSION_WRITE_ON_ANY_FOLDER = "permission.write.anyfolder";
    public static final String MSG_PERMISSION_TASK_CANCEL = "permission.task.cancel";
    public static final String MSG_PERMISSION_COMPONENT_NOT_INSTALLED = "permission.component.notinstalled";
    private String mURI;
    private String mTip;
    private String mName;
    private LinkAction mActionType;
    private String mMessage;
    private boolean mDimmed = false;
    private boolean mIsActionLink = true;

    public static Link createLink(String mode, int perms, LinkContext lc) {
        String uri = "javascript: sendHiddenForm(";
        if (mode != null) {
            uri = uri + "'" + mode + "'";
        }
        uri = uri + "); void (0);";
        return Link.simpleLink(uri, "Create new " + lc.getObjectType().toStringSingular(), ApplicationResources.getMessage("button.create"), perms, true, lc);
    }

    public static Link saveLink(LinkContext lc, int perms, boolean isSimple) {
        LinkAction action = null;
        if (!isSimple) {
            action = LinkAction.SAVED;
        }
        return new Link("javascript:sendForm('save'); void(0);", "Save changes", ApplicationResources.getMessage("button.save"), action, perms, true, lc);
    }

    public static Link deleteLink(LinkContext lc, int perms, boolean isSimple, String uri) {
        LinkAction action = null;
        if (!isSimple) {
            action = LinkAction.DELETED;
        }
        return new Link(uri, "Delete this " + lc.getObjectType().toStringSingular(), ApplicationResources.getMessage("button.delete"), action, perms, true, lc);
    }

    public static Link saveAsLink(LinkContext lc, int perms) {
        return Link.simpleLink("javascript:sendForm('saveas'); void(0);", "Save changes as new " + lc.getObjectType().toStringSingular(), ApplicationResources.getMessage("button.saveas"), perms, true, lc);
    }

    public static Link singleMoveLink(LinkContext lc) {
        return Link.complexLink("javascript:doMovePopup(); void(0);", "Move " + lc.getObjectType().toStringSingular() + " to another folder", ApplicationResources.getMessage("button.move"), LinkAction.MOVED, LinkContext.WRITE_ON_PLUGIN | LinkContext.WRITE_ON_FOLDER, true, lc);
    }

    public static Link singleRenameLink(LinkContext lc) {
        return Link.complexLink("javascript:doRenamePopup(); void(0);", "Rename this " + lc.getObjectType().toStringSingular(), ApplicationResources.getMessage("button.rename"), LinkAction.RENAMED, LinkContext.WRITE_ON_PLUGIN | LinkContext.WRITE_ON_FOLDER, true, lc);
    }

    public static Link singleFolderedDeleteLink(LinkContext lc) {
        String uri = "javascript:sendForm('delete'); void(0);";
        return Link.singleFolderedDeleteLink(lc, uri);
    }

    public static Link singleFolderedDeleteLink(LinkContext lc, String uri) {
        return Link.complexLink(uri, "Delete this " + lc.getObjectType().toStringSingular(), ApplicationResources.getMessage("button.delete"), LinkAction.DELETED, LinkContext.WRITE_ON_PLUGIN | LinkContext.WRITE_ON_FOLDER, true, lc);
    }

    public static Link bulkMoveLink(LinkContext lc) {
        return Link.complexLink("javascript: popupMovePrompt('bulk'); void(0);", "Move checked " + lc.getObjectType().toStringPlural(), "move...", LinkAction.MOVED, LinkContext.WRITE_ON_PLUGIN | LinkContext.WRITE_ON_FOLDER | LinkContext.IN_FLAT_VIEW, false, lc);
    }

    public static Link bulkDeleteLink(LinkContext lc, int perms, String uri) {
        return Link.simpleLink(uri, "Delete checked " + lc.getObjectType().toStringPlural(), "delete...", perms, false, lc);
    }

    public static Link bulkDeleteLink(LinkContext lc, int perms) {
        return Link.simpleLink("javascript: sendForm('delete'); void(0);", "Delete checked " + lc.getObjectType().toStringPlural(), "delete...", perms, false, lc);
    }

    public static Link bulkFolderedDeleteLinkPopup(LinkContext lc) {
        return Link.complexLink("javascript: popupDeletePrompt('bulk'); void(0);", "Delete checked " + lc.getObjectType().toStringPlural(), "delete...", LinkAction.DELETED, LinkContext.WRITE_ON_PLUGIN | LinkContext.WRITE_ON_FOLDER | LinkContext.IN_FLAT_VIEW, false, lc);
    }

    public static Link bulkFolderedApplyCategoriesLink(String checkboxID, LinkContext lc) {
        return Link.simpleLink("javascript: doApplyCategoriesPopup('bulk','" + checkboxID + "'); void(0);", "Apply categories to checked " + lc.getObjectType().toStringPlural(), "apply categories...", LinkContext.WRITE_ON_FOLDER | LinkContext.IN_FLAT_VIEW, false, lc);
    }

    public static Link simpleLink(String uri, String tip, String name, int neededPerms, boolean isActionLink, LinkContext lc) {
        return new Link(uri, tip, name, null, neededPerms, isActionLink, lc);
    }

    public static Link complexLink(String uri, String tip, String name, LinkAction actionType, int neededPerms, boolean isActionLink, LinkContext lc) {
        return new Link(uri, tip, name, actionType, neededPerms, isActionLink, lc);
    }

    private Link(String uri, String tip, String name, LinkAction actionType, int neededPerms, boolean isActionLink, LinkContext lc) {
        this.mURI = uri;
        this.mTip = tip;
        this.mName = name;
        this.mActionType = actionType;
        this.mIsActionLink = isActionLink;
        this.computePermissions(lc, neededPerms);
    }

    private void computePermissions(LinkContext lc, int needed) {
        String userLogin = lc.getUserLogin();
        LinkObject objectType = lc.getObjectType();
        boolean isSingularContext = lc.getIsSingularContext();
        if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_PLUGIN) && !lc.getWriteOnPlugin()) {
            this.mDimmed = true;
            this.mMessage = objectType != null && this.mActionType != null ? (isSingularContext ? ApplicationResources.getMessage(MSG_PERMISSION_PLUGIN_SINGULAR, objectType.toStringSingular(), this.mActionType.getAsString()) : ApplicationResources.getMessage(MSG_PERMISSION_PLUGIN_PLURAL, objectType.toStringPlural(), this.mActionType.getAsString())) : ApplicationResources.getMessage(MSG_PERMISSION_PLUGIN_SHORT);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_FOLDER) && !lc.getWriteOnFolder()) {
            if (!LinkContext.needsPerm(needed, LinkContext.IN_FLAT_VIEW) || !lc.getFlatView()) {
                this.mDimmed = true;
                this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE_ON_FOLDER, userLogin);
            }
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_PARENT_FOLDER) && !lc.getWriteOnParentFolder()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE_ON_PARENT_FOLDER, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.EXECUTE_ON_FOLDER) && !lc.getExecuteOnFolder()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_EXECUTE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.AUTORUN_ON_FOLDER) && !lc.getAutoRunOnFolder()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_AUTORUN, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.EXECUTE_ON_SYSTEM_FOLDER) && !lc.getExecuteOnSystemFolder()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_EXECUTE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_ANY_FOLDER) && !lc.getWriteOnAnyFolder()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE_ON_ANY_FOLDER, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.CHECKIN_CURRENT_ON_FOLDER) && !lc.getCheckinCurrentOnFolder()) {
            if (!LinkContext.needsPerm(needed, LinkContext.IN_FLAT_VIEW) || !lc.getFlatView()) {
                this.mDimmed = true;
                this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_CHECKIN_CURRENT, userLogin);
            }
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_DIFFS) && !lc.getWriteOnDiffs()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.DIFF_RUN) && !lc.getDiffRun()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_EXECUTE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_RULES) && !lc.getWriteOnRules()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_HOSTS) && !lc.getWriteOnHosts()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_HOST_SEARCHES) && !lc.getWriteOnHostSearches()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_HOST_SETS) && !lc.getWriteOnHostSets()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_HOST_TYPES) && !lc.getWriteOnHostTypes()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_USERS) && !lc.getWriteOnUsers()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_GROUPS) && !lc.getWriteOnGroups()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_COMPONENT_TYPES) && !lc.getWriteOnComponentTypes()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.WRITE_ON_SYSTEM_SERVICES) && !lc.getWriteOnSystemServices()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_WRITE, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.IS_TASK_OWNER) && !lc.getIsTaskOwner()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_TASK_CANCEL, userLogin);
        } else if (LinkContext.needsPerm(needed, LinkContext.COMPONENT_INSTALLED) && !lc.getComponentInstalled()) {
            this.mDimmed = true;
            this.mMessage = ApplicationResources.getMessage(MSG_PERMISSION_COMPONENT_NOT_INSTALLED, userLogin);
        }
    }

    public String renderAsText() {
        String link = null;
        if (!this.mDimmed) {
            link = this.mIsActionLink ? Util.actionLink(this.mURI, this.mTip, this.mName) : Util.standardLink(this.mURI, this.mTip, this.mName);
        } else {
            this.mURI = "javascript:warningPopup('" + ApplicationResources.getMessage(MSG_PERMISSION_HEADER) + "', '" + this.mMessage + "'); void(0);";
            this.mTip = this.mMessage;
            link = this.mIsActionLink ? Util.dimmedActionLink(this.mURI, this.mTip, this.mName) : Util.dimmedLink(this.mURI, this.mTip, this.mName);
        }
        return link;
    }

    public String renderAsButton() {
        return this.renderAsButton(true, null);
    }

    public String renderAsButton(String extra) {
        return this.renderAsButton(true, extra);
    }

    public String renderAsUntargetedButton() {
        return this.renderAsButton(false, null);
    }

    public String renderAsUntargetedButton(String extra) {
        return this.renderAsButton(false, extra);
    }

    public String renderAsButton(boolean targeted, String extra) {
        String button = null;
        if (this.mDimmed) {
            this.mURI = "javascript:warningPopup('" + ApplicationResources.getMessage(MSG_PERMISSION_HEADER) + "', '" + this.mMessage + "'); void(0);";
            this.mTip = this.mMessage;
        }
        button = targeted ? Util.standardButton(this.mURI, this.mTip, this.mName, this.mDimmed, extra) : Util.standardButtonUntargeted(this.mURI, this.mTip, this.mName, this.mDimmed, extra);
        return button;
    }
}

